/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.elasticsearch.gradle.FileSystemOperationsAware;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;

@CacheableTask
public abstract class LoggedExec
extends DefaultTask
implements FileSystemOperationsAware {
    private static final Logger LOGGER = Logging.getLogger(LoggedExec.class);
    protected FileSystemOperations fileSystemOperations;
    private ProjectLayout projectLayout;
    private ExecOperations execOperations;
    private String output;
    private static final Pattern NEWLINE = Pattern.compile(System.lineSeparator());

    @Input
    @Optional
    public abstract ListProperty<Object> getArgs();

    @Input
    @Optional
    public abstract MapProperty<String, String> getEnvironment();

    @Internal
    public abstract MapProperty<String, String> getNonTrackedEnvironment();

    @Input
    public abstract Property<String> getExecutable();

    @Input
    @Optional
    public abstract Property<String> getStandardInput();

    @Input
    @Optional
    public abstract Property<String> getIndentingConsoleOutput();

    @Input
    @Optional
    public abstract Property<Boolean> getCaptureOutput();

    @Input
    public Provider<String> getWorkingDirPath() {
        return this.getWorkingDir().map(file -> {
            String relativeWorkingDir = this.projectLayout.getProjectDirectory().getAsFile().toPath().relativize(file.toPath()).toString();
            return relativeWorkingDir;
        });
    }

    @Internal
    public abstract Property<File> getWorkingDir();

    @Inject
    public LoggedExec(ProjectLayout projectLayout, ExecOperations execOperations, FileSystemOperations fileSystemOperations, ProviderFactory providerFactory) {
        this.projectLayout = projectLayout;
        this.execOperations = execOperations;
        this.fileSystemOperations = fileSystemOperations;
        this.getWorkingDir().convention((Object)projectLayout.getProjectDirectory().getAsFile());
        this.setupDefaultEnvironment(providerFactory);
        this.getCaptureOutput().convention((Object)false);
    }

    private void setupDefaultEnvironment(ProviderFactory providerFactory) {
        Provider path;
        Provider javaRuntimeHome;
        this.getEnvironment().putAll(providerFactory.environmentVariablesPrefixedBy("GRADLE_BUILD_CACHE"));
        this.getNonTrackedEnvironment().putAll(providerFactory.environmentVariablesPrefixedBy("BUILDKITE"));
        this.getNonTrackedEnvironment().putAll(providerFactory.environmentVariablesPrefixedBy("VAULT"));
        Provider javaToolchainHome = providerFactory.environmentVariable("JAVA_TOOLCHAIN_HOME");
        if (javaToolchainHome.isPresent()) {
            this.getEnvironment().put((Object)"JAVA_TOOLCHAIN_HOME", javaToolchainHome);
        }
        if ((javaRuntimeHome = providerFactory.environmentVariable("RUNTIME_JAVA_HOME")).isPresent()) {
            this.getEnvironment().put((Object)"RUNTIME_JAVA_HOME", javaRuntimeHome);
        }
        if ((path = providerFactory.environmentVariable("PATH")).isPresent()) {
            this.getEnvironment().put((Object)"PATH", path);
        }
    }

    @TaskAction
    public void run() {
        if (((Boolean)this.getCaptureOutput().get()).booleanValue() && this.getIndentingConsoleOutput().isPresent()) {
            throw new GradleException("Capturing output is not supported when indentingConsoleOutput is configured.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Consumer<Logger> outputLogger = this.getIndentingConsoleOutput().isPresent() ? logger -> {} : logger -> logger.error(this.byteStreamToString(out));
        OutputStream finalOutputStream = this.getIndentingConsoleOutput().isPresent() ? new IndentingOutputStream(System.out, this.getIndentingConsoleOutput().get()) : out;
        ExecResult execResult = this.execOperations.exec(execSpec -> {
            execSpec.setIgnoreExitValue(true);
            execSpec.setStandardOutput(finalOutputStream);
            execSpec.setErrorOutput(finalOutputStream);
            execSpec.setExecutable((String)this.getExecutable().get());
            execSpec.environment((Map)this.getEnvironment().get());
            execSpec.environment((Map)this.getNonTrackedEnvironment().get());
            if (this.getArgs().isPresent()) {
                execSpec.setArgs((Iterable)this.getArgs().get());
            }
            if (this.getWorkingDir().isPresent()) {
                execSpec.setWorkingDir((File)this.getWorkingDir().get());
            }
            if (this.getStandardInput().isPresent()) {
                try {
                    execSpec.setStandardInput((InputStream)new ByteArrayInputStream(((String)this.getStandardInput().get()).getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GradleException("Cannot set standard input", (Throwable)e);
                }
            }
        });
        int exitValue = execResult.getExitValue();
        if (exitValue == 0 && ((Boolean)this.getCaptureOutput().get()).booleanValue()) {
            this.output = this.byteStreamToString(out);
        }
        if (!this.getLogger().isInfoEnabled() && exitValue != 0) {
            try {
                if (!this.getIndentingConsoleOutput().isPresent()) {
                    this.getLogger().error("Output for " + (String)this.getExecutable().get() + ":");
                }
                outputLogger.accept(this.getLogger());
            }
            catch (Exception e) {
                throw new GradleException("Failed to read exec output", (Throwable)e);
            }
            throw new GradleException(String.format("Process '%s %s' finished with non-zero exit value %d", this.getExecutable().get(), this.getArgs().get(), exitValue));
        }
    }

    private String byteStreamToString(OutputStream out) {
        return ((ByteArrayOutputStream)out).toString(StandardCharsets.UTF_8);
    }

    public static ExecResult exec(ExecOperations execOperations, Action<ExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((ExecOperations)execOperations).exec(arg_0), action);
    }

    public static ExecResult javaexec(ExecOperations project, Action<JavaExecSpec> action) {
        return LoggedExec.genericExec(arg_0 -> ((ExecOperations)project).javaexec(arg_0), action);
    }

    private static <T extends BaseExecSpec> ExecResult genericExec(Function<Action<T>, ExecResult> function, Action<T> action) {
        if (LOGGER.isInfoEnabled()) {
            return function.apply(action);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            return function.apply(spec -> {
                spec.setStandardOutput((OutputStream)output);
                spec.setErrorOutput((OutputStream)output);
                action.execute(spec);
                try {
                    output.write(("Output for " + spec.getExecutable() + ":").getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            if (output.size() != 0) {
                LOGGER.error("Exec output and error:");
                NEWLINE.splitAsStream(output.toString(StandardCharsets.UTF_8)).forEach(s -> LOGGER.error("| " + s));
            }
            throw e;
        }
    }

    @Override
    public WorkResult delete(Object ... objects) {
        return this.fileSystemOperations.delete(d -> d.delete(objects));
    }

    @Internal
    public String getOutput() {
        if (!((Boolean)this.getCaptureOutput().get()).booleanValue()) {
            throw new GradleException("Capturing output was not enabled. Use " + this.getName() + ".getCapturedOutput.set(true) to enable output capturing.");
        }
        return this.output;
    }

    public void args(Object ... args) {
        this.args(List.of(args));
    }

    public void args(List<Object> args) {
        this.getArgs().addAll(args);
    }

    public void commandLine(Object ... args) {
        this.commandLine(List.of(args));
    }

    public void commandLine(List<Object> args) {
        if (args.isEmpty()) {
            throw new IllegalArgumentException("Cannot set commandline with empty list.");
        }
        this.getExecutable().set((Object)args.get(0).toString());
        this.getArgs().set(args.subList(1, args.size()));
    }

    private static class IndentingOutputStream
    extends OutputStream {
        public final byte[] indent;
        private final OutputStream delegate;

        IndentingOutputStream(OutputStream delegate, Object version) {
            this.delegate = delegate;
            this.indent = (" [" + String.valueOf(version) + "] ").getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void write(int b) throws IOException {
            int[] arr = new int[]{b};
            this.write(arr, 0, 1);
        }

        public void write(int[] bytes, int offset, int length) throws IOException {
            for (int i = 0; i < bytes.length; ++i) {
                this.delegate.write(bytes[i]);
                if (bytes[i] != 10) continue;
                this.delegate.write(this.indent);
            }
        }
    }
}

