/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.StubRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;

public class InlineJoin
extends Join {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "InlineJoin", InlineJoin::readFrom);

    public static LogicalPlan stubSource(UnaryPlan sourcePlan, LogicalPlan target) {
        return sourcePlan.replaceChild(new StubRelation(sourcePlan.source(), target.output()));
    }

    public static LogicalPlan replaceStub(LogicalPlan source, LogicalPlan stubbed) {
        return (LogicalPlan)stubbed.transformUp(StubRelation.class, stubRelation -> source);
    }

    public static LogicalPlan inlineData(InlineJoin target, LocalRelation data) {
        if (target.config().matchFields().isEmpty()) {
            List<Attribute> schema = data.output();
            Block[] blocks = (Block[])data.supplier().get();
            ArrayList<Alias> aliases = new ArrayList<Alias>(schema.size());
            for (int i = 0; i < schema.size(); ++i) {
                Attribute attr = schema.get(i);
                aliases.add(new Alias(attr.source(), attr.name(), (Expression)Literal.of((Expression)attr, (Object)BlockUtils.toJavaObject((Block)blocks[i], (int)0)), attr.id()));
            }
            return new Eval(target.source(), target.left(), aliases);
        }
        return target.replaceRight(data);
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right, config);
    }

    public InlineJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right, type, matchFields, leftFields, rightFields);
    }

    private static InlineJoin readFrom(StreamInput in) throws IOException {
        PlanStreamInput planInput = (PlanStreamInput)in;
        Source source = Source.readFrom((StreamInput)planInput);
        LogicalPlan left = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        LogicalPlan right = (LogicalPlan)in.readNamedWriteable(LogicalPlan.class);
        JoinConfig config = new JoinConfig(in);
        return new InlineJoin(source, left, InlineJoin.replaceStub(left, right), config);
    }

    @Override
    public String getWriteableName() {
        return InlineJoin.ENTRY.name;
    }

    @Override
    protected NodeInfo<Join> info() {
        JoinConfig config = this.config();
        return NodeInfo.create((Node)this, InlineJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)config.type(), config.matchFields(), config.leftFields(), config.rightFields());
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new InlineJoin(this.source(), left, right, this.config());
    }

    @Override
    public List<Attribute> computeOutput(List<Attribute> left, List<Attribute> right) {
        ArrayList<Attribute> leftOutputWithoutMatchFields;
        JoinType joinType = this.config().type();
        if (JoinTypes.LEFT.equals(joinType)) {
            AttributeSet rightFields = AttributeSet.of(this.config().rightFields());
            leftOutputWithoutMatchFields = new ArrayList<Attribute>();
            for (Attribute attr : this.left().output()) {
                if (rightFields.contains((Object)attr)) continue;
                leftOutputWithoutMatchFields.add(attr);
            }
        } else {
            throw new IllegalArgumentException(joinType.joinName() + " unsupported");
        }
        List<Attribute> output = NamedExpressions.mergeOutputAttributes(right, leftOutputWithoutMatchFields);
        return output;
    }
}

