/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public interface LucenePushdownPredicates {
    public static final LucenePushdownPredicates DEFAULT = new LucenePushdownPredicates(){

        @Override
        public boolean hasExactSubfield(FieldAttribute attr) {
            return false;
        }

        @Override
        public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
            return attr.field().isAggregatable();
        }

        @Override
        public boolean isIndexed(FieldAttribute attr) {
            return attr.field().isAggregatable();
        }
    };

    public boolean hasExactSubfield(FieldAttribute var1);

    public boolean isIndexedAndHasDocValues(FieldAttribute var1);

    public boolean isIndexed(FieldAttribute var1);

    default public boolean isPushableFieldAttribute(Expression exp) {
        FieldAttribute fa;
        if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && this.isIndexedAndHasDocValues(fa)) {
            return fa.dataType() != DataType.TEXT && fa.dataType() != DataType.SEMANTIC_TEXT || this.hasExactSubfield(fa);
        }
        return false;
    }

    public static boolean isPushableTextFieldAttribute(Expression exp) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && ((fa = (FieldAttribute)exp).dataType() == DataType.TEXT || fa.dataType() == DataType.SEMANTIC_TEXT);
    }

    public static boolean isPushableMetadataAttribute(Expression exp) {
        MetadataAttribute ma;
        return exp instanceof MetadataAttribute && ((ma = (MetadataAttribute)exp).searchable() || ma.name().equals("_score"));
    }

    default public boolean isPushableAttribute(Expression exp) {
        return this.isPushableFieldAttribute(exp) || LucenePushdownPredicates.isPushableMetadataAttribute(exp);
    }

    public static TypedAttribute checkIsPushableAttribute(Expression e) {
        Check.isTrue((e instanceof FieldAttribute || e instanceof MetadataAttribute ? 1 : 0) != 0, (String)"Expected a FieldAttribute or MetadataAttribute but received [{}]", (Object[])new Object[]{e});
        return (TypedAttribute)e;
    }

    public static FieldAttribute checkIsFieldAttribute(Expression e) {
        Check.isTrue((boolean)(e instanceof FieldAttribute), (String)"Expected a FieldAttribute but received [{}] of type [{}]", (Object[])new Object[]{e, e.getClass()});
        return (FieldAttribute)e;
    }

    public static String pushableAttributeName(TypedAttribute attribute) {
        String string;
        if (attribute instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attribute;
            string = fa.exactAttribute().name();
        } else {
            string = attribute.name();
        }
        return string;
    }

    public static LucenePushdownPredicates from(final SearchStats stats) {
        return new LucenePushdownPredicates(){

            @Override
            public boolean hasExactSubfield(FieldAttribute attr) {
                return stats.hasExactSubfield(new FieldAttribute.FieldName(attr.name()));
            }

            @Override
            public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
                return attr.field().isAggregatable() || stats.isIndexed(new FieldAttribute.FieldName(attr.name())) && stats.hasDocValues(new FieldAttribute.FieldName(attr.name()));
            }

            @Override
            public boolean isIndexed(FieldAttribute attr) {
                return stats.isIndexed(new FieldAttribute.FieldName(attr.name()));
            }
        };
    }
}

