/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;

public final class ToDoubleFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator l;

    public ToDoubleFromLongEvaluator(Source source, EvalOperator.ExpressionEvaluator l, DriverContext driverContext) {
        super(driverContext, source);
        this.l = l;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.l;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantDoubleBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendDouble(this.evalValue(vector, p));
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToDouble.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    double value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendDouble(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private double evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToDouble.fromLong(value);
    }

    public String toString() {
        return "ToDoubleFromLongEvaluator[l=" + String.valueOf(this.l) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.l);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory l;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory l) {
            this.source = source;
            this.l = l;
        }

        public ToDoubleFromLongEvaluator get(DriverContext context) {
            return new ToDoubleFromLongEvaluator(this.source, this.l.get(context), context);
        }

        public String toString() {
            return "ToDoubleFromLongEvaluator[l=" + String.valueOf(this.l) + "]";
        }
    }
}

