/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.esql.action.EsqlResponse;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlResponseImpl;
import org.elasticsearch.xpack.esql.action.ResponseValueUtils;
import org.elasticsearch.xpack.esql.action.ResponseXContentUtils;
import org.elasticsearch.xpack.esql.core.type.DataType;

public class EsqlQueryResponse
extends org.elasticsearch.xpack.core.esql.action.EsqlQueryResponse
implements ChunkedToXContentObject,
Releasable {
    private final AbstractRefCounted counted = AbstractRefCounted.of(this::closeInternal);
    public static final String DROP_NULL_COLUMNS_OPTION = "drop_null_columns";
    private final List<ColumnInfoImpl> columns;
    private final List<Page> pages;
    private final Profile profile;
    private final boolean columnar;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isAsync;
    private final EsqlExecutionInfo executionInfo;
    private EsqlResponseImpl esqlResponse;

    public EsqlQueryResponse(List<ColumnInfoImpl> columns, List<Page> pages, @Nullable Profile profile, boolean columnar, @Nullable String asyncExecutionId, boolean isRunning, boolean isAsync, EsqlExecutionInfo executionInfo) {
        this.columns = columns;
        this.pages = pages;
        this.profile = profile;
        this.columnar = columnar;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isAsync = isAsync;
        this.executionInfo = executionInfo;
    }

    public EsqlQueryResponse(List<ColumnInfoImpl> columns, List<Page> pages, @Nullable Profile profile, boolean columnar, boolean isAsync, EsqlExecutionInfo executionInfo) {
        this(columns, pages, profile, columnar, null, false, isAsync, executionInfo);
    }

    public static Writeable.Reader<EsqlQueryResponse> reader(BlockFactory blockFactory) {
        return in -> {
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                EsqlQueryResponse esqlQueryResponse = EsqlQueryResponse.deserialize(bsi);
                return esqlQueryResponse;
            }
        };
    }

    static EsqlQueryResponse deserialize(BlockStreamInput in) throws IOException {
        String asyncExecutionId = null;
        boolean isRunning = false;
        boolean isAsync = false;
        Profile profile = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            asyncExecutionId = in.readOptionalString();
            isRunning = in.readBoolean();
            isAsync = in.readBoolean();
        }
        List columns = in.readCollectionAsList(ColumnInfoImpl::new);
        List pages = in.readCollectionAsList(Page::new);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            profile = (Profile)in.readOptionalWriteable(Profile::new);
        }
        boolean columnar = in.readBoolean();
        EsqlExecutionInfo executionInfo = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            executionInfo = (EsqlExecutionInfo)in.readOptionalWriteable(EsqlExecutionInfo::new);
        }
        return new EsqlQueryResponse(columns, pages, profile, columnar, asyncExecutionId, isRunning, isAsync, executionInfo);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeOptionalString(this.asyncExecutionId);
            out.writeBoolean(this.isRunning);
            out.writeBoolean(this.isAsync);
        }
        out.writeCollection(this.columns);
        out.writeCollection(this.pages);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeOptionalWriteable((Writeable)this.profile);
        }
        out.writeBoolean(this.columnar);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeOptionalWriteable((Writeable)this.executionInfo);
        }
    }

    public List<ColumnInfoImpl> columns() {
        return this.columns;
    }

    List<Page> pages() {
        return this.pages;
    }

    public Iterator<Iterator<Object>> values() {
        List<DataType> dataTypes = this.columns.stream().map(ColumnInfoImpl::type).toList();
        return ResponseValueUtils.pagesToValues(dataTypes, this.pages);
    }

    public Iterable<Iterable<Object>> rows() {
        List<DataType> dataTypes = this.columns.stream().map(ColumnInfoImpl::type).toList();
        return ResponseValueUtils.valuesForRowsInPages(dataTypes, this.pages);
    }

    public Iterator<Object> column(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            throw new IllegalArgumentException();
        }
        return ResponseValueUtils.valuesForColumn(columnIndex, this.columns.get(columnIndex).type(), this.pages);
    }

    public Profile profile() {
        return this.profile;
    }

    public boolean columnar() {
        return this.columnar;
    }

    public Optional<String> asyncExecutionId() {
        return Optional.ofNullable(this.asyncExecutionId);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public EsqlExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    private Iterator<? extends ToXContent> asyncPropertiesOrEmpty() {
        if (this.isAsync) {
            return ChunkedToXContentHelper.chunk((builder, params) -> {
                if (this.asyncExecutionId != null) {
                    builder.field("id", this.asyncExecutionId);
                }
                builder.field("is_running", this.isRunning);
                return builder;
            });
        }
        return Collections.emptyIterator();
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        boolean dropNullColumns = params.paramAsBoolean(DROP_NULL_COLUMNS_OPTION, false);
        boolean[] nullColumns = dropNullColumns ? this.nullColumns() : null;
        Iterator tookTime = this.executionInfo != null && this.executionInfo.overallTook() != null ? ChunkedToXContentHelper.chunk((builder, p) -> builder.field("took", this.executionInfo.overallTook().millis()).field(EsqlExecutionInfo.IS_PARTIAL_FIELD.getPreferredName(), this.executionInfo.isPartial())) : Collections.emptyIterator();
        Iterator columnHeadings = dropNullColumns ? Iterators.concat((Iterator[])new Iterator[]{ResponseXContentUtils.allColumns(this.columns, "all_columns"), ResponseXContentUtils.nonNullColumns(this.columns, nullColumns, "columns")}) : ResponseXContentUtils.allColumns(this.columns, "columns");
        Iterator<? extends ToXContent> valuesIt = ResponseXContentUtils.columnValues(this.columns, this.pages, this.columnar, nullColumns);
        Iterator profileRender = this.profile != null ? ChunkedToXContentHelper.field((String)"profile", (ChunkedToXContentObject)this.profile, (ToXContent.Params)params) : Collections.emptyIterator();
        Iterator executionInfoRender = this.executionInfo != null && this.executionInfo.isCrossClusterSearch() && this.executionInfo.includeCCSMetadata() ? ChunkedToXContentHelper.field((String)"_clusters", (ChunkedToXContentObject)this.executionInfo, (ToXContent.Params)params) : Collections.emptyIterator();
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), this.asyncPropertiesOrEmpty(), tookTime, columnHeadings, ChunkedToXContentHelper.array((String)"values", valuesIt), executionInfoRender, profileRender, ChunkedToXContentHelper.endObject()});
    }

    public boolean[] nullColumns() {
        boolean[] nullColumns = new boolean[this.columns.size()];
        for (int c = 0; c < nullColumns.length; ++c) {
            nullColumns[c] = this.allColumnsAreNull(c);
        }
        return nullColumns;
    }

    private boolean allColumnsAreNull(int c) {
        for (Page page : this.pages) {
            if (page.getBlock(c).areAllValuesNull()) continue;
            return false;
        }
        return true;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EsqlQueryResponse that = (EsqlQueryResponse)((Object)o);
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.asyncExecutionId, that.asyncExecutionId) && Objects.equals(this.isRunning, that.isRunning) && this.columnar == that.columnar && Iterators.equals(this.values(), that.values(), (row1, row2) -> Iterators.equals((Iterator)row1, (Iterator)row2, Objects::equals)) && Objects.equals(this.profile, that.profile) && Objects.equals(this.executionInfo, that.executionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.asyncExecutionId, this.isRunning, this.columns, Iterators.hashCode(this.values(), row -> Iterators.hashCode((Iterator)row, Objects::hashCode)), this.columnar, this.executionInfo);
    }

    public String toString() {
        return Strings.toString((ToXContent)ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)this));
    }

    public void incRef() {
        this.tryIncRef();
    }

    public boolean tryIncRef() {
        return this.counted.tryIncRef();
    }

    public boolean decRef() {
        return this.counted.decRef();
    }

    public boolean hasReferences() {
        return this.counted.hasReferences();
    }

    public void close() {
        super.close();
        this.decRef();
        if (this.esqlResponse != null) {
            this.esqlResponse.setClosedState();
        }
    }

    void closeInternal() {
        Releasables.close(() -> Iterators.map(this.pages.iterator(), p -> () -> ((Page)p).releaseBlocks()));
    }

    public EsqlResponse responseInternal() {
        if (!this.hasReferences()) {
            throw new IllegalStateException("closed");
        }
        if (this.esqlResponse != null) {
            return this.esqlResponse;
        }
        this.esqlResponse = new EsqlResponseImpl(this);
        return this.esqlResponse;
    }

    public static class Profile
    implements Writeable,
    ChunkedToXContentObject {
        private final List<DriverProfile> drivers;

        public Profile(List<DriverProfile> drivers) {
            this.drivers = drivers;
        }

        public Profile(StreamInput in) throws IOException {
            this.drivers = in.readCollectionAsImmutableList(DriverProfile::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.drivers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Profile profile = (Profile)o;
            return Objects.equals(this.drivers, profile.drivers);
        }

        public int hashCode() {
            return Objects.hash(this.drivers);
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.array((String)"drivers", this.drivers.iterator(), (ToXContent.Params)params), ChunkedToXContentHelper.endObject()});
        }

        List<DriverProfile> drivers() {
            return this.drivers;
        }
    }
}

