/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.mockito;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.ProtectionDomain;
import java.util.function.Supplier;
import org.mockito.plugins.MockMaker;

class SecureMockUtil {
    private static final AccessControlContext context = SecureMockUtil.getContext();

    private static AccessControlContext getContext() {
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[1];
        protectionDomainArray[0] = SecureMockUtil.wrap(MockMaker.class::getProtectionDomain);
        ProtectionDomain[] pda = protectionDomainArray;
        DomainCombiner combiner = (current, assigned) -> pda;
        AccessControlContext acc = new AccessControlContext(AccessController.getContext(), combiner);
        return AccessController.doPrivileged(AccessController::getContext, acc);
    }

    public static void init() {
    }

    static <T> T wrap(Supplier<T> call) {
        return (T)AccessController.doPrivileged(call::get, context);
    }

    private SecureMockUtil() {
    }
}

