/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.LambdaMatchers;
import org.elasticsearch.test.NotEqualMessageBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ElasticsearchAssertions {
    public static void assertAcked(RequestBuilder<?, ? extends IsAcknowledgedSupplier> builder) {
        ElasticsearchAssertions.assertAcked(builder, TimeValue.timeValueSeconds((long)30L));
    }

    @SafeVarargs
    public static void assertAcked(RequestBuilder<?, ? extends IsAcknowledgedSupplier> ... builders) {
        ArrayList<ActionFuture> futures = new ArrayList<ActionFuture>(builders.length);
        for (RequestBuilder<?, ? extends IsAcknowledgedSupplier> response : builders) {
            futures.add(response.execute());
        }
        Throwable tr = null;
        for (ActionFuture future : futures) {
            try {
                ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)future.get());
            }
            catch (Throwable t) {
                tr = ExceptionsHelper.useOrSuppress(tr, (Throwable)t);
            }
        }
        if (tr != null) {
            throw new AssertionError((Object)tr);
        }
    }

    @SafeVarargs
    public static void assertAcked(ActionFuture<? extends IsAcknowledgedSupplier> ... futures) {
        if (futures.length == 1) {
            ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)futures[0].actionGet());
            return;
        }
        Throwable tr = null;
        for (ActionFuture<? extends IsAcknowledgedSupplier> future : futures) {
            try {
                ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)future.get());
            }
            catch (Throwable t) {
                tr = ExceptionsHelper.useOrSuppress(tr, (Throwable)t);
            }
        }
        if (tr != null) {
            throw new AssertionError((Object)tr);
        }
    }

    public static void assertAcked(RequestBuilder<?, ? extends IsAcknowledgedSupplier> builder, TimeValue timeValue) {
        ElasticsearchAssertions.assertAcked((IsAcknowledgedSupplier)builder.get(timeValue));
    }

    public static void assertNoTimeout(ClusterHealthRequestBuilder requestBuilder) {
        ElasticsearchAssertions.assertNoTimeout((ClusterHealthResponse)requestBuilder.get());
    }

    public static void assertNoTimeout(ClusterHealthResponse response) {
        MatcherAssert.assertThat((String)("ClusterHealthResponse has timed out - returned: [" + String.valueOf(response) + "]"), (Object)response.isTimedOut(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertAcked(IsAcknowledgedSupplier response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    /*
     * WARNING - void declaration
     */
    public static void assertAcked(CreateIndexRequestBuilder ... requests) {
        void var4_6;
        if (requests.length == 1) {
            ElasticsearchAssertions.assertAcked(requests[0]);
            return;
        }
        ArrayList<ActionFuture> futures = new ArrayList<ActionFuture>(requests.length);
        CreateIndexRequestBuilder[] createIndexRequestBuilderArray = requests;
        int n = createIndexRequestBuilderArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            CreateIndexRequestBuilder response = createIndexRequestBuilderArray[var4_6];
            futures.add(response.execute());
            ++var4_6;
        }
        Throwable tr = null;
        for (Future future : futures) {
            try {
                ElasticsearchAssertions.assertAcked((CreateIndexResponse)future.get());
            }
            catch (Throwable t) {
                tr = ExceptionsHelper.useOrSuppress(tr, (Throwable)t);
            }
        }
        if (tr != null) {
            throw new AssertionError((Object)tr);
        }
    }

    public static void assertAcked(CreateIndexResponse response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - index creation acked but not all shards were started"), (Object)response.isShardsAcknowledged(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertBlocked(RequestBuilder<?, ?> builder) {
        ElasticsearchAssertions.assertBlocked(builder, (ClusterBlock)null);
    }

    public static void assertBlocked(BaseBroadcastResponse replicatedBroadcastResponse) {
        MatcherAssert.assertThat((String)"all shard requests should have failed", (Object)replicatedBroadcastResponse.getFailedShards(), (Matcher)CoreMatchers.equalTo((Object)replicatedBroadcastResponse.getTotalShards()));
        for (DefaultShardOperationFailedException exception : replicatedBroadcastResponse.getShardFailures()) {
            ClusterBlockException clusterBlockException = (ClusterBlockException)ExceptionsHelper.unwrap((Throwable)exception.getCause(), (Class[])new Class[]{ClusterBlockException.class});
            Assert.assertNotNull((String)("expected the cause of failure to be a ClusterBlockException but got " + exception.getCause().getMessage()), (Object)clusterBlockException);
            MatcherAssert.assertThat((Object)clusterBlockException.blocks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
            RestStatus status = ElasticsearchAssertions.checkRetryableBlock(clusterBlockException.blocks()) ? RestStatus.TOO_MANY_REQUESTS : RestStatus.FORBIDDEN;
            MatcherAssert.assertThat((Object)clusterBlockException.status(), (Matcher)CoreMatchers.equalTo((Object)status));
        }
    }

    public static void assertBlocked(RequestBuilder<?, ?> builder, @Nullable Integer expectedBlockId) {
        ElasticsearchAssertions.assertBlocked(expectedBlockId, (Exception)ESTestCase.expectThrows(ClusterBlockException.class, builder));
    }

    public static void assertBlocked(@Nullable Integer expectedBlockId, Exception exception) {
        ClusterBlockException e = ESTestCase.asInstanceOf(ClusterBlockException.class, exception);
        MatcherAssert.assertThat((Object)e.blocks(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)e.status(), (Matcher)CoreMatchers.equalTo((Object)(ElasticsearchAssertions.checkRetryableBlock(e.blocks()) ? RestStatus.TOO_MANY_REQUESTS : RestStatus.FORBIDDEN)));
        if (expectedBlockId != null) {
            MatcherAssert.assertThat((String)("Request should have been blocked by [" + expectedBlockId + "] instead of " + String.valueOf(e.blocks())), (Object)e.blocks(), (Matcher)Matchers.hasItem(LambdaMatchers.transformedMatch("ClusterBlock id", ClusterBlock::id, CoreMatchers.equalTo((Object)expectedBlockId))));
        }
    }

    public static void assertBlocked(RequestBuilder<?, ?> builder, @Nullable ClusterBlock expectedBlock) {
        ElasticsearchAssertions.assertBlocked(builder, expectedBlock != null ? Integer.valueOf(expectedBlock.id()) : null);
    }

    private static boolean checkRetryableBlock(Set<ClusterBlock> clusterBlocks) {
        return clusterBlocks.stream().allMatch(clusterBlock -> clusterBlock.id() == IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK.id());
    }

    public static String formatShardStatus(BaseBroadcastResponse response) {
        StringBuilder msg = new StringBuilder();
        msg.append(" Total shards: ").append(response.getTotalShards()).append(" Successful shards: ").append(response.getSuccessfulShards()).append(" & ").append(response.getFailedShards()).append(" shard failures:");
        for (DefaultShardOperationFailedException failure : response.getShardFailures()) {
            msg.append("\n ").append(failure);
        }
        return msg.toString();
    }

    public static String formatShardStatus(SearchResponse response) {
        StringBuilder msg = new StringBuilder();
        msg.append(" Total shards: ").append(response.getTotalShards()).append(" Successful shards: ").append(response.getSuccessfulShards()).append(" & ").append(response.getFailedShards()).append(" shard failures:");
        for (ShardSearchFailure failure : response.getShardFailures()) {
            msg.append("\n ").append(failure);
        }
        return msg.toString();
    }

    public static void assertNoSearchHits(SearchRequestBuilder searchRequestBuilder) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, ElasticsearchAssertions::assertNoSearchHits);
    }

    public static void assertNoSearchHits(SearchResponse searchResponse) {
        MatcherAssert.assertThat((Object)searchResponse.getHits().getHits(), (Matcher)Matchers.emptyArray());
    }

    public static void assertSearchHits(SearchRequestBuilder searchRequestBuilder, String ... ids) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R res) -> ElasticsearchAssertions.assertSearchHits(res, ids));
    }

    public static void assertSearchHits(SearchResponse searchResponse, String ... ids) {
        MatcherAssert.assertThat((String)("Incorrect SearchHit ids. " + ElasticsearchAssertions.formatShardStatus(searchResponse)), (Object)searchResponse.getHits(), LambdaMatchers.transformedItemsMatch(SearchHit::getId, Matchers.containsInAnyOrder((Object[])ids)));
    }

    public static void assertSearchHitsWithoutFailures(SearchRequestBuilder requestBuilder, String ... ids) {
        ElasticsearchAssertions.assertResponse(requestBuilder, (R res) -> {
            ElasticsearchAssertions.assertNoFailures(res);
            ElasticsearchAssertions.assertHitCount(res, (long)ids.length);
            ElasticsearchAssertions.assertSearchHits(res, ids);
        });
    }

    public static void assertSortValues(SearchRequestBuilder searchRequestBuilder, Object[] ... sortValues) {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)searchRequestBuilder, (SearchResponse res) -> {
            SearchHit[] hits = res.getHits().getHits();
            Assert.assertEquals((long)sortValues.length, (long)hits.length);
            for (int i = 0; i < sortValues.length; ++i) {
                Object[] hitsSortValues = hits[i].getSortValues();
                Assert.assertArrayEquals((String)("Offset " + i + ", id " + hits[i].getId()), (Object[])sortValues[i], (Object[])hitsSortValues);
            }
        });
    }

    public static void assertOrderedSearchHits(SearchRequestBuilder searchRequestBuilder, String ... ids) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R res) -> ElasticsearchAssertions.assertOrderedSearchHits(res, ids));
    }

    public static void assertOrderedSearchHits(SearchResponse searchResponse, String ... ids) {
        MatcherAssert.assertThat((String)("Incorrect SearchHit ids. " + ElasticsearchAssertions.formatShardStatus(searchResponse)), (Object)searchResponse.getHits().getHits(), LambdaMatchers.transformedArrayItemsMatch(SearchHit::getId, (Matcher<U[]>)Matchers.arrayContaining((Object[])ids)));
    }

    public static void assertHitCount(SearchRequestBuilder searchRequestBuilder, long expectedHitCount) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R res) -> ElasticsearchAssertions.assertHitCount(res, expectedHitCount));
    }

    public static void assertHitCount(long expectedHitCount, SearchRequestBuilder ... searchRequestBuilders) {
        ElasticsearchAssertions.assertResponses(res -> ElasticsearchAssertions.assertHitCount(res, expectedHitCount), searchRequestBuilders);
    }

    public static void assertHitCount(ActionFuture<SearchResponse> responseFuture, long expectedHitCount) {
        try {
            ElasticsearchAssertions.assertResponse(responseFuture, (R res) -> ElasticsearchAssertions.assertHitCount(res, expectedHitCount));
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void assertHitCount(SearchResponse countResponse, long expectedHitCount) {
        TotalHits totalHits = countResponse.getHits().getTotalHits();
        if (totalHits.relation() != TotalHits.Relation.EQUAL_TO || totalHits.value() != expectedHitCount) {
            Assert.fail((String)("Count is " + String.valueOf(totalHits) + " but " + expectedHitCount + " was expected. " + ElasticsearchAssertions.formatShardStatus(countResponse)));
        }
    }

    public static void assertHitCountAndNoFailures(SearchRequestBuilder searchRequestBuilder, long expectedHitCount) {
        ElasticsearchAssertions.assertNoFailuresAndResponse((RequestBuilder<? extends ActionRequest, SearchResponse>)searchRequestBuilder, (SearchResponse response) -> ElasticsearchAssertions.assertHitCount(response, expectedHitCount));
    }

    public static void assertExists(GetResponse response) {
        String message = String.format(Locale.ROOT, "Expected %s/%s to exist, but does not", response.getIndex(), response.getId());
        MatcherAssert.assertThat((String)message, (Object)response.isExists(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFirstHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 1, matcher);
    }

    public static void assertSecondHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 2, matcher);
    }

    public static void assertThirdHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 3, matcher);
    }

    public static void assertFourthHit(SearchResponse searchResponse, Matcher<SearchHit> matcher) {
        ElasticsearchAssertions.assertSearchHit(searchResponse, 4, matcher);
    }

    public static void assertSearchHit(SearchResponse searchResponse, int number, Matcher<SearchHit> matcher) {
        MatcherAssert.assertThat((String)"SearchHit number must be greater than 0", (Object)number, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)searchResponse.getHits().getTotalHits().value(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(number)));
        MatcherAssert.assertThat((Object)searchResponse.getHits().getAt(number - 1), matcher);
    }

    public static void assertNoFailures(RequestBuilder<? extends ActionRequest, SearchResponse> searchRequestBuilder) {
        ElasticsearchAssertions.assertNoFailuresAndResponse(searchRequestBuilder, (SearchResponse r) -> {});
    }

    public static void assertNoFailuresAndResponse(RequestBuilder<? extends ActionRequest, SearchResponse> searchRequestBuilder, Consumer<SearchResponse> consumer) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R res) -> {
            ElasticsearchAssertions.assertNoFailures(res);
            consumer.accept((SearchResponse)res);
        });
    }

    public static void assertNoFailuresAndResponse(ActionFuture<SearchResponse> responseFuture, Consumer<SearchResponse> consumer) throws ExecutionException, InterruptedException {
        SearchResponse res = (SearchResponse)responseFuture.get();
        try {
            ElasticsearchAssertions.assertNoFailures(res);
            consumer.accept(res);
        }
        finally {
            res.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <Q extends ActionRequest, R extends ActionResponse> void assertResponses(Consumer<R> consumer, RequestBuilder<Q, R> ... searchRequestBuilder) {
        void var5_7;
        ArrayList<ActionFuture> futures = new ArrayList<ActionFuture>(searchRequestBuilder.length);
        RequestBuilder<Q, R>[] requestBuilderArray = searchRequestBuilder;
        int n = requestBuilderArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            RequestBuilder<Q, R> builder = requestBuilderArray[var5_7];
            futures.add(builder.execute());
            ++var5_7;
        }
        Throwable tr = null;
        for (Future future : futures) {
            try {
                ActionResponse res = (ActionResponse)future.get();
                try {
                    consumer.accept(res);
                }
                finally {
                    res.decRef();
                }
            }
            catch (Throwable t) {
                tr = ExceptionsHelper.useOrSuppress(tr, (Throwable)t);
            }
        }
        if (tr != null) {
            throw new AssertionError((Object)tr);
        }
    }

    public static <Q extends ActionRequest, R extends ActionResponse> void assertResponse(RequestBuilder<Q, R> searchRequestBuilder, Consumer<R> consumer) {
        ActionResponse res = (ActionResponse)searchRequestBuilder.get();
        try {
            consumer.accept(res);
        }
        finally {
            res.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertScrollResponsesAndHitCount(Client client, TimeValue keepAlive, SearchRequestBuilder searchRequestBuilder, int expectedTotalHitCount, BiConsumer<Integer, SearchResponse> responseConsumer) {
        searchRequestBuilder.setScroll(keepAlive);
        ArrayList<SearchResponse> responses = new ArrayList<SearchResponse>();
        SearchResponse scrollResponse = (SearchResponse)searchRequestBuilder.get();
        responses.add(scrollResponse);
        int retrievedDocsCount = 0;
        try {
            MatcherAssert.assertThat((Object)scrollResponse.getHits().getTotalHits().value(), (Matcher)CoreMatchers.equalTo((Object)expectedTotalHitCount));
            retrievedDocsCount += scrollResponse.getHits().getHits().length;
            responseConsumer.accept(responses.size(), scrollResponse);
            while (scrollResponse.getHits().getHits().length > 0) {
                scrollResponse = (SearchResponse)client.prepareSearchScroll(scrollResponse.getScrollId()).setScroll(keepAlive).get();
                responses.add(scrollResponse);
                MatcherAssert.assertThat((Object)scrollResponse.getHits().getTotalHits().value(), (Matcher)CoreMatchers.equalTo((Object)expectedTotalHitCount));
                retrievedDocsCount += scrollResponse.getHits().getHits().length;
                responseConsumer.accept(responses.size(), scrollResponse);
            }
        }
        catch (Throwable throwable) {
            ClearScrollResponse clearResponse = (ClearScrollResponse)client.prepareClearScroll().setScrollIds(Arrays.asList(scrollResponse.getScrollId())).get();
            responses.forEach(SearchResponse::decRef);
            MatcherAssert.assertThat((Object)clearResponse.isSucceeded(), (Matcher)Matchers.equalTo((Object)true));
            throw throwable;
        }
        ClearScrollResponse clearResponse = (ClearScrollResponse)client.prepareClearScroll().setScrollIds(Arrays.asList(scrollResponse.getScrollId())).get();
        responses.forEach(SearchResponse::decRef);
        MatcherAssert.assertThat((Object)clearResponse.isSucceeded(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)retrievedDocsCount, (Matcher)CoreMatchers.equalTo((Object)expectedTotalHitCount));
    }

    public static <R extends ActionResponse> void assertResponse(ActionFuture<R> responseFuture, Consumer<R> consumer) throws ExecutionException, InterruptedException {
        ActionResponse res = (ActionResponse)responseFuture.get();
        try {
            consumer.accept(res);
        }
        finally {
            res.decRef();
        }
    }

    public static void assertCheckedResponse(RequestBuilder<?, SearchResponse> searchRequestBuilder, CheckedConsumer<SearchResponse, IOException> consumer) throws IOException {
        SearchResponse res = (SearchResponse)searchRequestBuilder.get();
        try {
            consumer.accept((Object)res);
        }
        finally {
            res.decRef();
        }
    }

    public static void assertCheckedResponse(ActionFuture<SearchResponse> responseFuture, CheckedConsumer<SearchResponse, IOException> consumer) throws IOException, ExecutionException, InterruptedException {
        SearchResponse res = (SearchResponse)responseFuture.get();
        try {
            consumer.accept((Object)res);
        }
        finally {
            res.decRef();
        }
    }

    public static void assertNoFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + Arrays.toString(searchResponse.getShardFailures())), (Object)searchResponse.getShardFailures(), (Matcher)Matchers.emptyArray());
    }

    public static void assertFailures(SearchResponse searchResponse) {
        MatcherAssert.assertThat((String)"Expected at least one shard failure, got none", (Object)searchResponse.getShardFailures(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
    }

    public static void assertNoFailures(BulkResponse response) {
        MatcherAssert.assertThat((String)("Unexpected ShardFailures: " + response.buildFailureMessage()), (Object)response.hasFailures(), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertFailures(SearchRequestBuilder searchRequestBuilder, RestStatus restStatus, Matcher<String> reasonMatcher) {
        ElasticsearchAssertions.assertFailures(searchRequestBuilder, Set.of(restStatus), reasonMatcher);
    }

    public static void assertFailures(SearchRequestBuilder searchRequestBuilder, Set<RestStatus> restStatuses, Matcher<String> reasonMatcher) {
        try {
            ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R response) -> {
                MatcherAssert.assertThat((String)"Expected shard failures, got none", (Object)response.getShardFailures(), (Matcher)Matchers.not((Matcher)Matchers.emptyArray()));
                for (ShardSearchFailure shardSearchFailure : response.getShardFailures()) {
                    MatcherAssert.assertThat((Object)restStatuses, (Matcher)Matchers.hasItem((Object)shardSearchFailure.status()));
                    MatcherAssert.assertThat((Object)shardSearchFailure.reason(), (Matcher)reasonMatcher);
                }
            });
        }
        catch (SearchPhaseExecutionException e) {
            MatcherAssert.assertThat(restStatuses, (Matcher)Matchers.hasItem((Object)e.status()));
            MatcherAssert.assertThat((Object)e.toString(), reasonMatcher);
            for (ShardSearchFailure shardSearchFailure : e.shardFailures()) {
                MatcherAssert.assertThat(restStatuses, (Matcher)Matchers.hasItem((Object)shardSearchFailure.status()));
                MatcherAssert.assertThat((Object)shardSearchFailure.reason(), reasonMatcher);
            }
        }
        catch (Exception e) {
            Assert.fail((String)("SearchPhaseExecutionException expected but got " + String.valueOf(e.getClass())));
        }
    }

    public static void assertFailures(SearchRequestBuilder searchRequestBuilder, RestStatus restStatus) {
        ElasticsearchAssertions.assertFailures(searchRequestBuilder, restStatus, (Matcher<String>)Matchers.containsString((String)""));
    }

    public static void assertNoFailures(BaseBroadcastResponse response) {
        if (response.getFailedShards() != 0) {
            AssertionError assertionError = new AssertionError((Object)("[" + response.getFailedShards() + "] shard failures"));
            for (DefaultShardOperationFailedException shardFailure : response.getShardFailures()) {
                ((Throwable)((Object)assertionError)).addSuppressed((Throwable)new ElasticsearchException(shardFailure.toString(), shardFailure.getCause(), new Object[0]));
            }
            throw assertionError;
        }
    }

    public static void assertAllSuccessful(BaseBroadcastResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)"Expected all shards successful", (Object)response.getSuccessfulShards(), (Matcher)CoreMatchers.equalTo((Object)response.getTotalShards()));
    }

    public static void assertAllSuccessful(SearchResponse response) {
        ElasticsearchAssertions.assertNoFailures(response);
        MatcherAssert.assertThat((String)"Expected all shards successful", (Object)response.getSuccessfulShards(), (Matcher)CoreMatchers.equalTo((Object)response.getTotalShards()));
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchRequestBuilder searchRequestBuilder, int hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R response) -> ElasticsearchAssertions.assertHighlight(response, hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher));
    }

    public static void assertHighlight(ActionFuture<SearchResponse> responseFuture, int hit, String field, int fragment, int totalFragments, Matcher<String> matcher) throws ExecutionException, InterruptedException {
        ElasticsearchAssertions.assertResponse(responseFuture, (R response) -> ElasticsearchAssertions.assertHighlight(response, hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher));
    }

    public static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(resp, hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)Matchers.greaterThan((Comparable)Integer.valueOf(fragment)), matcher);
    }

    public static void assertHighlight(SearchHit hit, String field, int fragment, int totalFragments, Matcher<String> matcher) {
        ElasticsearchAssertions.assertHighlight(hit, field, fragment, (Matcher<Integer>)CoreMatchers.equalTo((Object)totalFragments), matcher);
    }

    private static void assertHighlight(SearchResponse resp, int hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().getHits(), (Matcher)Matchers.arrayWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit))));
        ElasticsearchAssertions.assertHighlight(resp.getHits().getHits()[hit], field, fragment, fragmentsMatcher, matcher);
    }

    private static void assertHighlight(SearchHit hit, String field, int fragment, Matcher<Integer> fragmentsMatcher, Matcher<String> matcher) {
        MatcherAssert.assertThat((Object)hit.getHighlightFields(), (Matcher)Matchers.hasKey((Object)field));
        MatcherAssert.assertThat((Object)((HighlightField)hit.getHighlightFields().get(field)).fragments(), (Matcher)Matchers.arrayWithSize(fragmentsMatcher));
        MatcherAssert.assertThat((Object)((HighlightField)hit.getHighlightFields().get(field)).fragments()[fragment].string(), matcher);
    }

    public static void assertNotHighlighted(SearchRequestBuilder searchRequestBuilder, int hit, String field) {
        ElasticsearchAssertions.assertResponse(searchRequestBuilder, (R response) -> ElasticsearchAssertions.assertNotHighlighted(response, hit, field));
    }

    public static void assertNotHighlighted(SearchResponse resp, int hit, String field) {
        ElasticsearchAssertions.assertNoFailures(resp);
        MatcherAssert.assertThat((String)"not enough hits", (Object)resp.getHits().getHits(), (Matcher)Matchers.arrayWithSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(hit))));
        MatcherAssert.assertThat((Object)resp.getHits().getHits()[hit].getHighlightFields(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)field)));
    }

    public static void assertSuggestionSize(Suggest searchSuggest, int entry, int size, String key) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + searchSuggest.toString();
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry))));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions(), (Matcher)Matchers.hasSize((int)size));
    }

    public static void assertSuggestionPhraseCollateMatchExists(Suggest searchSuggest, String key, int numberOfPhraseExists) {
        int counter = 0;
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + String.valueOf(searchSuggest);
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        for (Suggest.Suggestion.Entry.Option option : ((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(0)).getOptions()) {
            if (!option.collateMatch()) continue;
            ++counter;
        }
        MatcherAssert.assertThat((Object)counter, (Matcher)CoreMatchers.equalTo((Object)numberOfPhraseExists));
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, int ord, String key, String text) {
        MatcherAssert.assertThat((Object)searchSuggest, (Matcher)Matchers.notNullValue());
        String msg = "Suggest result: " + String.valueOf(searchSuggest);
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getName(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((String)msg, (Object)searchSuggest.getSuggestion(key).getEntries(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(entry))));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(ord))));
        MatcherAssert.assertThat((String)msg, (Object)((Suggest.Suggestion.Entry.Option)((Suggest.Suggestion.Entry)searchSuggest.getSuggestion(key).getEntries().get(entry)).getOptions().get(ord)).getText().string(), (Matcher)CoreMatchers.equalTo((Object)text));
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, String ... text) {
        ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, key, text.length, text);
    }

    public static void assertSuggestion(Suggest searchSuggest, int entry, String key, int size, String ... text) {
        ElasticsearchAssertions.assertSuggestionSize(searchSuggest, entry, size, key);
        for (int i = 0; i < text.length; ++i) {
            ElasticsearchAssertions.assertSuggestion(searchSuggest, entry, i, key, text[i]);
        }
    }

    public static void assertIndexTemplateMissing(GetIndexTemplatesResponse templatesResponse, String name) {
        MatcherAssert.assertThat((Object)templatesResponse.getIndexTemplates(), (Matcher)Matchers.not((Matcher)Matchers.hasItem(LambdaMatchers.transformedMatch("IndexTemplateMetadata name", IndexTemplateMetadata::name, CoreMatchers.equalTo((Object)name)))));
    }

    public static void assertIndexTemplateExists(GetIndexTemplatesResponse templatesResponse, String name) {
        MatcherAssert.assertThat((Object)templatesResponse.getIndexTemplates(), (Matcher)Matchers.hasItem(LambdaMatchers.transformedMatch("IndexTemplateMetadata name", IndexTemplateMetadata::name, CoreMatchers.equalTo((Object)name))));
    }

    public static Matcher<SearchHit> hasId(String id) {
        return LambdaMatchers.transformedMatch("SearchHit id", SearchHit::getId, CoreMatchers.equalTo((Object)id));
    }

    public static Matcher<SearchHit> hasIndex(String index) {
        return LambdaMatchers.transformedMatch("SearchHit index", SearchHit::getIndex, CoreMatchers.equalTo((Object)index));
    }

    public static Matcher<SearchHit> hasScore(float score) {
        return LambdaMatchers.transformedMatch("SearchHit score", SearchHit::getScore, CoreMatchers.equalTo((Object)Float.valueOf(score)));
    }

    public static Matcher<SearchHit> hasRank(int rank) {
        return LambdaMatchers.transformedMatch("SearchHit rank", SearchHit::getRank, CoreMatchers.equalTo((Object)rank));
    }

    public static <T extends Query> T assertBooleanSubQuery(Query query, Class<T> subqueryType, int i) {
        MatcherAssert.assertThat((Object)query, (Matcher)Matchers.instanceOf(BooleanQuery.class));
        BooleanQuery q = (BooleanQuery)query;
        MatcherAssert.assertThat((Object)q.clauses(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i))));
        MatcherAssert.assertThat((Object)((BooleanClause)q.clauses().get(i)).query(), (Matcher)Matchers.instanceOf(subqueryType));
        return (T)((Query)subqueryType.cast(((BooleanClause)q.clauses().get(i)).query()));
    }

    public static <E extends Throwable> void assertRequestBuilderThrows(RequestBuilder<?, ?> builder, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertFutureThrows(builder.execute(), exceptionClass, status);
    }

    public static <E extends Throwable> void assertRequestBuilderThrows(RequestBuilder<?, ?> builder, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertFutureThrows(builder.execute(), exceptionClass, extraInfo);
    }

    public static <E extends Throwable> void assertFutureThrows(ActionFuture<?> future, Class<E> exceptionClass) {
        ElasticsearchAssertions.assertFutureThrows(future, exceptionClass, null, null);
    }

    public static <E extends Throwable> void assertFutureThrows(ActionFuture<?> future, Class<E> exceptionClass, RestStatus status) {
        ElasticsearchAssertions.assertFutureThrows(future, exceptionClass, status, null);
    }

    public static <E extends Throwable> void assertFutureThrows(ActionFuture<?> future, Class<E> exceptionClass, String extraInfo) {
        ElasticsearchAssertions.assertFutureThrows(future, exceptionClass, null, extraInfo);
    }

    public static <E extends Throwable> void assertFutureThrows(ActionFuture<?> future, Class<E> exceptionClass, @Nullable RestStatus status, @Nullable String extraInfo) {
        Throwable expected;
        extraInfo = extraInfo == null || ((String)extraInfo).isEmpty() ? "" : (String)extraInfo + ": ";
        extraInfo = (String)extraInfo + "expected a " + String.valueOf(exceptionClass) + " exception to be thrown";
        if (status != null) {
            extraInfo = (String)extraInfo + " with status [" + String.valueOf(status) + "]";
        }
        if ((expected = LuceneTestCase.expectThrowsAnyOf(List.of(exceptionClass, ElasticsearchException.class), () -> future.actionGet())) instanceof ElasticsearchException) {
            MatcherAssert.assertThat((String)extraInfo, (Object)((ElasticsearchException)expected).unwrapCause(), (Matcher)Matchers.instanceOf(exceptionClass));
        } else {
            MatcherAssert.assertThat((String)extraInfo, (Object)expected, (Matcher)Matchers.instanceOf(exceptionClass));
        }
        if (status != null) {
            MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)expected), (Matcher)CoreMatchers.equalTo((Object)status));
        }
    }

    public static void assertRequestBuilderThrows(RequestBuilder<?, ?> builder, RestStatus status) {
        ElasticsearchAssertions.assertFutureThrows(builder.execute(), status);
    }

    public static void assertRequestBuilderThrows(RequestBuilder<?, ?> builder, RestStatus status, String extraInfo) {
        ElasticsearchAssertions.assertFutureThrows(builder.execute(), status, extraInfo);
    }

    public static void assertFutureThrows(ActionFuture<?> future, RestStatus status) {
        ElasticsearchAssertions.assertFutureThrows(future, status, null);
    }

    public static void assertFutureThrows(ActionFuture<?> future, RestStatus status, String extraInfo) {
        extraInfo = extraInfo == null || ((String)extraInfo).isEmpty() ? "" : (String)extraInfo + ": ";
        extraInfo = (String)extraInfo + "expected a " + String.valueOf(status) + " status exception to be thrown";
        Exception e = (Exception)LuceneTestCase.expectThrows(Exception.class, () -> future.actionGet());
        MatcherAssert.assertThat((String)extraInfo, (Object)ExceptionsHelper.status((Throwable)e), (Matcher)CoreMatchers.equalTo((Object)status));
    }

    public static void assertFileExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + String.valueOf(file) + "] should exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assertFileNotExists(Path file) {
        MatcherAssert.assertThat((String)("file/dir [" + String.valueOf(file) + "] should not exist."), (Object)Files.exists(file, new LinkOption[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    public static void assertToXContentEquivalent(BytesReference expected, BytesReference actual, XContentType xContentType) throws IOException {
        Map actualMap = null;
        Map expectedMap = null;
        try (XContentParser actualParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)actual, (XContentType)xContentType);){
            actualMap = actualParser.map();
            try (XContentParser expectedParser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)expected, (XContentType)xContentType);){
                expectedMap = expectedParser.map();
                try {
                    ElasticsearchAssertions.assertMapEquals(expectedMap, actualMap);
                }
                catch (AssertionError error) {
                    NotEqualMessageBuilder message = new NotEqualMessageBuilder();
                    message.compareMaps(actualMap, expectedMap);
                    throw new AssertionError("Error when comparing xContent.\n" + message.toString(), (Throwable)((Object)error));
                }
            }
        }
    }

    public static void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
        TimeValue timeValue = new TimeValue(timeout, unit);
        String message = String.format(Locale.ROOT, "expected latch to be counted down after %s, but was not", timeValue);
        boolean isCountedDown = latch.await(timeout, unit);
        MatcherAssert.assertThat((String)message, (Object)isCountedDown, (Matcher)CoreMatchers.is((Object)true));
    }

    public static <T extends ActionResponse> void assertWarningHeaderOnResponse(Client client, ActionRequestBuilder<?, T> requestBuilder, String toMatch) throws InterruptedException {
        ElasticsearchAssertions.assertWarningHeaderMatchOnResponse(client, requestBuilder, (Matcher<? super List<String>>)Matchers.hasItem((Matcher)Matchers.containsString((String)toMatch)));
    }

    public static <T extends ActionResponse> void assertNoWarningHeaderOnResponse(Client client, ActionRequestBuilder<?, T> requestBuilder, String toMatch) throws InterruptedException {
        ElasticsearchAssertions.assertWarningHeaderMatchOnResponse(client, requestBuilder, (Matcher<? super List<String>>)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)toMatch))));
    }

    private static <T extends ActionResponse> void assertWarningHeaderMatchOnResponse(final Client client, ActionRequestBuilder<?, T> requestBuilder, final Matcher<? super List<String>> matcher) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        requestBuilder.execute(new ActionListener<T>(){

            public void onResponse(T response) {
                try {
                    List warningHeaders = (List)client.threadPool().getThreadContext().getResponseHeaders().get("Warning");
                    MatcherAssert.assertThat((Object)warningHeaders, (Matcher)matcher);
                }
                finally {
                    latch.countDown();
                }
            }

            public void onFailure(Exception e) {
                try {
                    throw new AssertionError("Failed to execute request", e);
                }
                catch (Throwable throwable) {
                    latch.countDown();
                    throw throwable;
                }
            }
        });
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Did not receive request response before timeout");
        }
    }

    private static void assertMapEquals(Map<String, Object> expected, Map<String, Object> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
            String expectedKey = expectedEntry.getKey();
            Object expectedValue = expectedEntry.getValue();
            if (expectedValue == null) {
                Assert.assertTrue((actual.get(expectedKey) == null && actual.containsKey(expectedKey) ? 1 : 0) != 0);
                continue;
            }
            Object actualValue = actual.get(expectedKey);
            ElasticsearchAssertions.assertObjectEquals(expectedValue, actualValue);
        }
    }

    private static void assertListEquals(List<Object> expected, List<Object> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<Object> actualIterator = actual.iterator();
        for (Object expectedValue : expected) {
            Object actualValue = actualIterator.next();
            ElasticsearchAssertions.assertObjectEquals(expectedValue, actualValue);
        }
    }

    private static void assertObjectEquals(Object expected, Object actual) {
        if (expected instanceof Map) {
            MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.instanceOf(Map.class));
            ElasticsearchAssertions.assertMapEquals((Map)expected, (Map)actual);
        } else if (expected instanceof List) {
            ElasticsearchAssertions.assertListEquals((List)expected, (List)actual);
        } else if (expected instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])actual));
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

