/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.version.CompatibilityVersionsUtils;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterServiceUtils {
    public static void setState(ClusterApplierService executor, ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        executor.onNewClusterState("test setting state", () -> ClusterState.builder((ClusterState)clusterState).version(clusterState.version() + 1L).build(), (ActionListener)new ActionListener<Void>(){

            public void onResponse(Void ignored) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                exception.set(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (exception.get() != null) {
                Throwables.rethrow((Throwable)((Throwable)exception.get()));
            }
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException("unexpected exception", (Throwable)e, new Object[0]);
        }
    }

    public static void setState(MasterService executor, final ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        executor.submitUnbatchedStateUpdateTask("test setting state", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                return ClusterState.builder((ClusterState)clusterState).build();
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                TestCase.fail((String)("unexpected exception" + String.valueOf(e)));
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ElasticsearchException("unexpected interruption", (Throwable)e, new Object[0]);
        }
    }

    public static ClusterService createClusterService(ThreadPool threadPool) {
        return ClusterServiceUtils.createClusterService(threadPool, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode) {
        return ClusterServiceUtils.createClusterService(threadPool, localNode, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public static ClusterService createClusterService(ThreadPool threadPool, ClusterSettings clusterSettings) {
        DiscoveryNode discoveryNode = DiscoveryNodeUtils.create("node", "node");
        return ClusterServiceUtils.createClusterService(threadPool, discoveryNode, clusterSettings);
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode, ClusterSettings clusterSettings) {
        return ClusterServiceUtils.createClusterService(threadPool, localNode, Settings.EMPTY, clusterSettings);
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode, Settings providedSettings, ClusterSettings clusterSettings) {
        Settings settings = Settings.builder().put("node.name", "test").put("cluster.name", "ClusterServiceTests").put(providedSettings).build();
        ClusterService clusterService = new ClusterService(settings, clusterSettings, threadPool, new TaskManager(settings, threadPool, Collections.emptySet(), Tracer.NOOP));
        clusterService.setNodeConnectionsService(ClusterServiceUtils.createNoOpNodeConnectionsService());
        ClusterState initialClusterState = ClusterState.builder((ClusterName)new ClusterName(ClusterServiceUtils.class.getSimpleName())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).masterNodeId(localNode.getId())).putCompatibilityVersions(localNode.getId(), CompatibilityVersionsUtils.staticCurrent()).blocks(ClusterBlocks.EMPTY_CLUSTER_BLOCK).build();
        clusterService.getClusterApplierService().setInitialState(initialClusterState);
        clusterService.getMasterService().setClusterStatePublisher(ClusterServiceUtils.createClusterStatePublisher((ClusterApplier)clusterService.getClusterApplierService()));
        clusterService.getMasterService().setClusterStateSupplier(() -> ((ClusterApplierService)clusterService.getClusterApplierService()).state());
        clusterService.start();
        return clusterService;
    }

    public static NodeConnectionsService createNoOpNodeConnectionsService() {
        return new NodeConnectionsService(Settings.EMPTY, null, null){

            public void connectToNodes(DiscoveryNodes discoveryNodes, Runnable onCompletion) {
                onCompletion.run();
            }

            public void disconnectFromNodesExcept(DiscoveryNodes nodesToKeep) {
            }
        };
    }

    public static ClusterStatePublisher createClusterStatePublisher(ClusterApplier clusterApplier) {
        return (clusterStatePublicationEvent, publishListener, ackListener) -> {
            ClusterServiceUtils.setAllElapsedMillis(clusterStatePublicationEvent);
            clusterApplier.onNewClusterState("mock_publish_to_self[" + String.valueOf(clusterStatePublicationEvent.getSummary()) + "]", () -> ((ClusterStatePublicationEvent)clusterStatePublicationEvent).getNewState(), publishListener);
        };
    }

    public static ClusterService createClusterService(ClusterState initialState, ThreadPool threadPool) {
        ClusterService clusterService = ClusterServiceUtils.createClusterService(threadPool);
        ClusterServiceUtils.setState(clusterService, initialState);
        return clusterService;
    }

    public static ClusterService createClusterService(ClusterState initialState, ThreadPool threadPool, ClusterSettings clusterSettings) {
        ClusterService clusterService = ClusterServiceUtils.createClusterService(threadPool, clusterSettings);
        ClusterServiceUtils.setState(clusterService, initialState);
        return clusterService;
    }

    public static void setState(ClusterService clusterService, ClusterState.Builder clusterStateBuilder) {
        ClusterServiceUtils.setState(clusterService, clusterStateBuilder.build());
    }

    public static void setState(ClusterService clusterService, ClusterState clusterState) {
        ClusterServiceUtils.setState(clusterService.getClusterApplierService(), clusterState);
    }

    public static void setAllElapsedMillis(ClusterStatePublicationEvent clusterStatePublicationEvent) {
        clusterStatePublicationEvent.setPublicationContextConstructionElapsedMillis(0L);
        clusterStatePublicationEvent.setPublicationCommitElapsedMillis(0L);
        clusterStatePublicationEvent.setPublicationCompletionElapsedMillis(0L);
        clusterStatePublicationEvent.setMasterApplyElapsedMillis(0L);
    }

    public static void awaitClusterState(Logger logger, Predicate<ClusterState> statePredicate, final ClusterService clusterService) throws Exception {
        final PlainActionFuture future = new PlainActionFuture();
        ClusterStateObserver.waitForState((ClusterService)clusterService, (ThreadContext)clusterService.getClusterApplierService().threadPool().getThreadContext(), (ClusterStateObserver.Listener)new ClusterStateObserver.Listener(){

            public void onNewClusterState(ClusterState state) {
                future.onResponse(null);
            }

            public void onClusterServiceClose() {
                future.onFailure((Exception)new NodeClosedException(clusterService.localNode()));
            }

            public void onTimeout(TimeValue timeout) {
                assert (false) : "onTimeout called with no timeout set";
            }
        }, statePredicate, null, (Logger)logger);
        future.get(30L, TimeUnit.SECONDS);
    }

    public static void awaitNoPendingTasks(ClusterService clusterService) {
        ESTestCase.safeAwait(listener -> clusterService.submitUnbatchedStateUpdateTask("await-queue-empty", new ClusterStateUpdateTask(Priority.LANGUID, ESTestCase.SAFE_AWAIT_TIMEOUT, (ActionListener)listener){
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$listener = actionListener;
                super(arg0, arg1);
            }

            public ClusterState execute(ClusterState currentState) {
                return currentState;
            }

            public void onFailure(Exception e) {
                this.val$listener.onFailure(e);
            }

            public void clusterStateProcessed(ClusterState initialState, ClusterState newState) {
                this.val$listener.onResponse(null);
            }
        }));
    }

    public static SubscribableListener<Void> addTemporaryStateListener(ClusterService clusterService, Predicate<ClusterState> predicate) {
        return ClusterServiceUtils.addTemporaryStateListener(clusterService, predicate, ESTestCase.SAFE_AWAIT_TIMEOUT);
    }

    public static SubscribableListener<Void> addTemporaryStateListener(ClusterService clusterService, final Predicate<ClusterState> predicate, TimeValue timeout) {
        final SubscribableListener listener = new SubscribableListener();
        ClusterStateListener clusterStateListener = new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent event) {
                try {
                    if (predicate.test(event.state())) {
                        listener.onResponse(null);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }

            public String toString() {
                return predicate.toString();
            }
        };
        clusterService.addListener(clusterStateListener);
        listener.addListener(ActionListener.running(() -> clusterService.removeListener(clusterStateListener)));
        if (predicate.test(clusterService.state())) {
            listener.onResponse(null);
        } else {
            listener.addTimeout(timeout, clusterService.threadPool(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        }
        return listener;
    }

    public static SubscribableListener<Void> addTemporaryStateListener(Predicate<ClusterState> predicate) {
        return ClusterServiceUtils.addTemporaryStateListener(ESIntegTestCase.internalCluster().clusterService(), predicate);
    }

    public static SubscribableListener<Void> addMasterTemporaryStateListener(Predicate<ClusterState> predicate) {
        return ClusterServiceUtils.addTemporaryStateListener(ESIntegTestCase.internalCluster().getCurrentMasterNodeInstance(ClusterService.class), predicate);
    }
}

