/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.matchers.source;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logsdb.datageneration.matchers.MatchResult;
import org.elasticsearch.logsdb.datageneration.matchers.Messages;
import org.elasticsearch.xcontent.XContentBuilder;

class DynamicFieldMatcher {
    private final XContentBuilder actualMappings;
    private final Settings.Builder actualSettings;
    private final XContentBuilder expectedMappings;
    private final Settings.Builder expectedSettings;

    DynamicFieldMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
        this.actualMappings = actualMappings;
        this.actualSettings = actualSettings;
        this.expectedMappings = expectedMappings;
        this.expectedSettings = expectedSettings;
    }

    public Optional<MatchResult> match(List<Object> actual, List<Object> expected) {
        if (expected == null) {
            return Optional.empty();
        }
        Boolean isDouble = expected.stream().filter(Objects::nonNull).findFirst().map(o -> o instanceof Double).orElse(false);
        if (isDouble.booleanValue()) {
            Set<Float> normalizedExpected;
            assert (expected.stream().allMatch(o -> o == null || o instanceof Double));
            Set<Float> normalizedActual = DynamicFieldMatcher.normalizeDoubles(actual);
            MatchResult matchResult = normalizedActual.equals(normalizedExpected = DynamicFieldMatcher.normalizeDoubles(expected)) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of dynamically mapped field containing double values don't match after normalization, normalized " + Messages.prettyPrintCollections(normalizedActual, normalizedExpected)));
            return Optional.of(matchResult);
        }
        return Optional.empty();
    }

    private static Set<Float> normalizeDoubles(List<Object> values) {
        if (values == null) {
            return Set.of();
        }
        Function<Object, Float> toFloat = o -> {
            Float f;
            if (o instanceof Number) {
                Number n = (Number)o;
                f = Float.valueOf(n.floatValue());
            } else {
                f = Float.valueOf(Float.parseFloat((String)o));
            }
            return f;
        };
        return values.stream().filter(Objects::nonNull).map(toFloat).collect(Collectors.toSet());
    }
}

