/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.datasource;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.test.ESTestCase;

public class DefaultObjectGenerationHandler
implements DataSourceHandler {
    private static final Set<FieldType> EXCLUDED_FROM_DYNAMIC_MAPPING = Set.of(FieldType.UNSIGNED_LONG);

    @Override
    public DataSourceResponse.ChildFieldGenerator handle(final DataSourceRequest.ChildFieldGenerator request) {
        return new DataSourceResponse.ChildFieldGenerator(){

            @Override
            public int generateChildFieldCount() {
                return ESTestCase.randomIntBetween(0, request.specification().maxFieldCountPerLevel());
            }

            @Override
            public boolean generateDynamicSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateNestedSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public boolean generateRegularSubObject() {
                return ESTestCase.randomDouble() <= 0.05;
            }

            @Override
            public String generateFieldName() {
                return ESTestCase.randomAlphaOfLengthBetween(1, 10);
            }
        };
    }

    @Override
    public DataSourceResponse.FieldTypeGenerator handle(DataSourceRequest.FieldTypeGenerator request) {
        return new DataSourceResponse.FieldTypeGenerator(() -> new DataSourceResponse.FieldTypeGenerator.FieldTypeInfo(ESTestCase.randomFrom(FieldType.values())));
    }

    @Override
    public DataSourceResponse.ObjectArrayGenerator handle(DataSourceRequest.ObjectArrayGenerator request) {
        return new DataSourceResponse.ObjectArrayGenerator(() -> {
            if (ESTestCase.randomBoolean()) {
                return Optional.of(ESTestCase.randomIntBetween(0, 5));
            }
            return Optional.empty();
        });
    }

    @Override
    public DataSourceResponse.DynamicMappingGenerator handle(DataSourceRequest.DynamicMappingGenerator request) {
        return new DataSourceResponse.DynamicMappingGenerator(isObject -> isObject.booleanValue() ? ESTestCase.randomDouble() <= 0.05 : ESTestCase.randomBoolean());
    }
}

