/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration.datasource;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.logsdb.datageneration.FieldType;

public interface DataSourceResponse {

    public record DynamicMappingGenerator(Function<Boolean, Boolean> generator) implements DataSourceResponse
    {
    }

    public record ObjectMappingParametersGenerator(Supplier<Map<String, Object>> mappingGenerator) implements DataSourceResponse
    {
    }

    public record LeafMappingParametersGenerator(Supplier<Map<String, Object>> mappingGenerator) implements DataSourceResponse
    {
    }

    public record ObjectArrayGenerator(Supplier<Optional<Integer>> lengthGenerator) implements DataSourceResponse
    {
    }

    public record FieldTypeGenerator(Supplier<FieldTypeInfo> generator) implements DataSourceResponse
    {

        public record FieldTypeInfo(FieldType fieldType) {
        }
    }

    public static interface ChildFieldGenerator
    extends DataSourceResponse {
        public int generateChildFieldCount();

        public boolean generateDynamicSubObject();

        public boolean generateNestedSubObject();

        public boolean generateRegularSubObject();

        public String generateFieldName();
    }

    public record ArrayWrapper(Function<Supplier<Object>, Supplier<Object>> wrapper) implements DataSourceResponse
    {
    }

    public record NullWrapper(Function<Supplier<Object>, Supplier<Object>> wrapper) implements DataSourceResponse
    {
    }

    public record StringGenerator(Supplier<String> generator) implements DataSourceResponse
    {
    }

    public record HalfFloatGenerator(Supplier<Float> generator) implements DataSourceResponse
    {
    }

    public record FloatGenerator(Supplier<Float> generator) implements DataSourceResponse
    {
    }

    public record DoubleGenerator(Supplier<Double> generator) implements DataSourceResponse
    {
    }

    public record ByteGenerator(Supplier<Byte> generator) implements DataSourceResponse
    {
    }

    public record ShortGenerator(Supplier<Short> generator) implements DataSourceResponse
    {
    }

    public record IntegerGenerator(Supplier<Integer> generator) implements DataSourceResponse
    {
    }

    public record UnsignedLongGenerator(Supplier<Object> generator) implements DataSourceResponse
    {
    }

    public record LongGenerator(Supplier<Long> generator) implements DataSourceResponse
    {
    }
}

