/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.logsdb.datageneration;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.Mapping;
import org.elasticsearch.logsdb.datageneration.Template;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.logsdb.datageneration.fields.DynamicMapping;
import org.elasticsearch.logsdb.datageneration.fields.PredefinedField;

public class MappingGenerator {
    private final DataGeneratorSpecification specification;
    private final DataSourceResponse.DynamicMappingGenerator dynamicMappingGenerator;

    public MappingGenerator(DataGeneratorSpecification specification) {
        this.specification = specification;
        this.dynamicMappingGenerator = specification.dataSource().get(new DataSourceRequest.DynamicMappingGenerator());
    }

    public Mapping generate(Template template) {
        TreeMap<String, Map<String, Object>> lookup = new TreeMap<String, Map<String, Object>>();
        Supplier<Map<String, Object>> mappingParametersGenerator = this.specification.dataSource().get(new DataSourceRequest.ObjectMappingParametersGenerator(true, false, ObjectMapper.Subobjects.ENABLED)).mappingGenerator();
        Map<String, Object> topLevelMappingParameters = mappingParametersGenerator.get();
        topLevelMappingParameters.remove("enabled");
        TreeMap<String, Object> rawMapping = new TreeMap<String, Object>();
        TreeMap<String, Object> childrenMapping = new TreeMap<String, Object>();
        for (PredefinedField predefinedField : this.specification.predefinedFields()) {
            if (predefinedField.mapping() == null) continue;
            childrenMapping.put(predefinedField.name(), predefinedField.mapping());
            lookup.put(predefinedField.name(), predefinedField.mapping());
        }
        topLevelMappingParameters.put("properties", childrenMapping);
        rawMapping.put("_doc", topLevelMappingParameters);
        if (this.specification.fullyDynamicMapping()) {
            topLevelMappingParameters.remove("dynamic");
            return new Mapping(rawMapping, lookup);
        }
        DynamicMapping dynamicMapping = topLevelMappingParameters.getOrDefault("dynamic", "true").equals("strict") ? DynamicMapping.FORBIDDEN : DynamicMapping.SUPPORTED;
        ObjectMapper.Subobjects subobjects = ObjectMapper.Subobjects.from((Object)topLevelMappingParameters.getOrDefault("subobjects", "true"));
        this.generateMapping(childrenMapping, lookup, template.template(), new Context(new HashSet<String>(), "", subobjects, dynamicMapping));
        return new Mapping(rawMapping, lookup);
    }

    private void generateMapping(Map<String, Object> mapping, Map<String, Map<String, Object>> lookup, Map<String, Template.Entry> template, Context context) {
        for (Map.Entry<String, Template.Entry> entry : template.entrySet()) {
            String fieldName = entry.getKey();
            Template.Entry templateEntry = entry.getValue();
            TreeMap<String, Object> mappingParameters = new TreeMap<String, Object>();
            boolean isDynamicallyMapped = this.isDynamicallyMapped(templateEntry, context);
            if (isDynamicallyMapped) continue;
            if (templateEntry instanceof Template.Leaf) {
                Template.Leaf leaf = (Template.Leaf)templateEntry;
                mappingParametersGenerator = this.specification.dataSource().get(new DataSourceRequest.LeafMappingParametersGenerator(fieldName, leaf.type(), context.eligibleCopyToDestinations(), context.parentDynamicMapping())).mappingGenerator();
                mappingParameters.put("type", leaf.type().toString());
                mappingParameters.putAll(mappingParametersGenerator.get());
                if (leaf.type() == FieldType.KEYWORD) {
                    context.addCopyToCandidate(fieldName);
                }
            } else if (templateEntry instanceof Template.Object) {
                Template.Object object = (Template.Object)templateEntry;
                mappingParametersGenerator = this.specification.dataSource().get(new DataSourceRequest.ObjectMappingParametersGenerator(false, object.nested(), context.parentSubobjects())).mappingGenerator();
                mappingParameters.put("type", object.nested() ? "nested" : "object");
                mappingParameters.putAll(mappingParametersGenerator.get());
                TreeMap<String, Object> childrenMapping = new TreeMap<String, Object>();
                mappingParameters.put("properties", childrenMapping);
                this.generateMapping(childrenMapping, lookup, object.children(), context.stepIntoObject(object.name(), object.nested(), mappingParameters));
            }
            mapping.put(fieldName, mappingParameters);
            lookup.put(context.pathTo(fieldName), Map.copyOf(mappingParameters));
        }
    }

    private boolean isDynamicallyMapped(Template.Entry templateEntry, Context context) {
        return context.parentDynamicMapping != DynamicMapping.FORBIDDEN && this.dynamicMappingGenerator.generator().apply(templateEntry instanceof Template.Object) != false;
    }

    record Context(Set<String> eligibleCopyToDestinations, String path, ObjectMapper.Subobjects parentSubobjects, DynamicMapping parentDynamicMapping) {
        Context stepIntoObject(String name, boolean nested, Map<String, Object> mappingParameters) {
            ObjectMapper.Subobjects subobjects = this.determineSubobjects(mappingParameters);
            DynamicMapping dynamicMapping = this.determineDynamicMapping(mappingParameters);
            return new Context(nested ? new HashSet() : this.eligibleCopyToDestinations, this.pathTo(name), subobjects, dynamicMapping);
        }

        void addCopyToCandidate(String leafFieldName) {
            this.eligibleCopyToDestinations.add(this.pathTo(leafFieldName));
        }

        String pathTo(String leafFieldName) {
            return this.path.isEmpty() ? leafFieldName : this.path + "." + leafFieldName;
        }

        private DynamicMapping determineDynamicMapping(Map<String, Object> mappingParameters) {
            if (this.parentDynamicMapping == DynamicMapping.FORCED) {
                return DynamicMapping.FORCED;
            }
            Object dynamicParameter = mappingParameters.get("dynamic");
            if (dynamicParameter == null) {
                return this.parentDynamicMapping;
            }
            return dynamicParameter.equals("strict") ? DynamicMapping.FORBIDDEN : DynamicMapping.SUPPORTED;
        }

        private ObjectMapper.Subobjects determineSubobjects(Map<String, Object> mappingParameters) {
            if (this.parentSubobjects == ObjectMapper.Subobjects.DISABLED) {
                return ObjectMapper.Subobjects.DISABLED;
            }
            return ObjectMapper.Subobjects.from((Object)mappingParameters.getOrDefault("subobjects", "true"));
        }
    }
}

