/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class NumberTypeOutOfRangeSpec {
    final NumberFieldMapper.NumberType type;
    final Object value;
    final String message;

    public static NumberTypeOutOfRangeSpec of(NumberFieldMapper.NumberType t, Object v, String m) {
        return new NumberTypeOutOfRangeSpec(t, v, m);
    }

    NumberTypeOutOfRangeSpec(NumberFieldMapper.NumberType t, Object v, String m) {
        this.type = t;
        this.value = v;
        this.message = m;
    }

    public void write(XContentBuilder b) throws IOException {
        if (this.value instanceof BigInteger) {
            b.rawField("field", (InputStream)new ByteArrayInputStream(this.value.toString().getBytes("UTF-8")), XContentType.JSON);
        } else {
            b.field("field", this.value);
        }
    }
}

