/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TestBlock;
import org.elasticsearch.logsdb.datageneration.DataGeneratorSpecification;
import org.elasticsearch.logsdb.datageneration.FieldDataGenerator;
import org.elasticsearch.logsdb.datageneration.FieldType;
import org.elasticsearch.logsdb.datageneration.Mapping;
import org.elasticsearch.logsdb.datageneration.MappingGenerator;
import org.elasticsearch.logsdb.datageneration.Template;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceHandler;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.logsdb.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public abstract class BlockLoaderTestCase
extends MapperServiceTestCase {
    private final String fieldName = BlockLoaderTestCase.randomAlphaOfLengthBetween(5, 10);
    private final Template template;
    private final MappingGenerator mappingGenerator;
    private final FieldDataGenerator generator;

    protected BlockLoaderTestCase(FieldType fieldType) {
        DataGeneratorSpecification specification = DataGeneratorSpecification.builder().withFullyDynamicMapping(false).withDataSourceHandlers(List.of(new DataSourceHandler(this){

            @Override
            public DataSourceResponse.DynamicMappingGenerator handle(DataSourceRequest.DynamicMappingGenerator request) {
                return new DataSourceResponse.DynamicMappingGenerator(isObject -> false);
            }
        })).build();
        this.template = new Template(Map.of(this.fieldName, new Template.Leaf(this.fieldName, fieldType)));
        this.mappingGenerator = new MappingGenerator(specification);
        this.generator = fieldType.generator(this.fieldName, specification.dataSource());
    }

    public void testBlockLoader() throws IOException {
        Mapping mapping = this.mappingGenerator.generate(this.template);
        XContentBuilder mappingXContent = XContentBuilder.builder((XContent)XContentType.JSON.xContent()).map(mapping.raw());
        boolean syntheticSource = BlockLoaderTestCase.randomBoolean();
        MapperService mapperService = syntheticSource ? this.createSytheticSourceMapperService(mappingXContent) : this.createMapperService(mappingXContent);
        Object fieldValue = this.generator.generateValue();
        Object blockLoaderResult = this.setupAndInvokeBlockLoader(mapperService, fieldValue);
        Object expected = this.expected(mapping.lookup().get(this.fieldName), fieldValue, syntheticSource);
        BlockLoaderTestCase.assertEquals((Object)expected, (Object)blockLoaderResult);
    }

    protected abstract Object expected(Map<String, Object> var1, Object var2, boolean var3);

    private Object setupAndInvokeBlockLoader(MapperService mapperService, Object fieldValue) throws IOException {
        try (BaseDirectoryWrapper directory = BlockLoaderTestCase.newDirectory();){
            Object object;
            block12: {
                RandomIndexWriter iw = new RandomIndexWriter(BlockLoaderTestCase.random(), (Directory)directory);
                LuceneDocument doc = mapperService.documentMapper().parse(BlockLoaderTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                    b.field(this.fieldName);
                    b.value(fieldValue);
                }))).rootDoc();
                iw.addDocument((Iterable)doc);
                iw.close();
                DirectoryReader reader = DirectoryReader.open((Directory)directory);
                try {
                    LeafReaderContext context = (LeafReaderContext)reader.leaves().get(0);
                    object = this.load(this.createBlockLoader(mapperService), context, mapperService);
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return object;
        }
    }

    private Object load(BlockLoader blockLoader, LeafReaderContext context, MapperService mapperService) throws IOException {
        BlockLoader.ColumnAtATimeReader columnAtATimeReader = blockLoader.columnAtATimeReader(context);
        if (columnAtATimeReader != null) {
            TestBlock block = (TestBlock)columnAtATimeReader.read(TestBlock.factory(context.reader().numDocs()), TestBlock.docs(0));
            return block.get(0);
        }
        StoredFieldsSpec storedFieldsSpec = blockLoader.rowStrideStoredFieldSpec();
        SourceLoader.Leaf leafSourceLoader = null;
        if (storedFieldsSpec.requiresSource()) {
            SourceLoader sourceLoader = mapperService.mappingLookup().newSourceLoader(null, SourceFieldMetrics.NOOP);
            leafSourceLoader = sourceLoader.leaf(context.reader(), null);
            storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(true, storedFieldsSpec.requiresMetadata(), sourceLoader.requiredStoredFields()));
        }
        BlockLoaderStoredFieldsFromLeafLoader storedFieldsLoader = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(context, null), leafSourceLoader);
        storedFieldsLoader.advanceTo(0);
        BlockLoader.Builder builder = blockLoader.builder(TestBlock.factory(context.reader().numDocs()), 1);
        blockLoader.rowStrideReader(context).read(0, (BlockLoader.StoredFields)storedFieldsLoader, builder);
        TestBlock block = (TestBlock)builder.build();
        return block.get(0);
    }

    private BlockLoader createBlockLoader(final MapperService mapperService) {
        final SearchLookup searchLookup = new SearchLookup(arg_0 -> ((FieldTypeLookup)mapperService.mappingLookup().fieldTypesLookup()).get(arg_0), null, null);
        return mapperService.fieldType(this.fieldName).blockLoader(new MappedFieldType.BlockLoaderContext(){

            public String indexName() {
                return mapperService.getIndexSettings().getIndex().getName();
            }

            public IndexSettings indexSettings() {
                return mapperService.getIndexSettings();
            }

            public MappedFieldType.FieldExtractPreference fieldExtractPreference() {
                return MappedFieldType.FieldExtractPreference.NONE;
            }

            public SearchLookup lookup() {
                return searchLookup;
            }

            public Set<String> sourcePaths(String name) {
                return mapperService.mappingLookup().sourcePaths(name);
            }

            public String parentField(String field) {
                return mapperService.mappingLookup().parentField(field);
            }

            public FieldNamesFieldMapper.FieldNamesFieldType fieldNames() {
                return (FieldNamesFieldMapper.FieldNamesFieldType)mapperService.fieldType("_field_names");
            }
        });
    }
}

