/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;

public class ClusterChangedEventUtils {
    public static List<String> indicesCreated(ClusterChangedEvent event) {
        if (!event.metadataChanged()) {
            return Collections.emptyList();
        }
        ClusterState state = event.state();
        ClusterState previousState = event.previousState();
        ArrayList<String> created = new ArrayList<String>();
        for (Map.Entry cursor : state.metadata().indices().entrySet()) {
            String index = (String)cursor.getKey();
            if (previousState.metadata().hasIndex(index)) {
                IndexMetadata currIndexMetadata = (IndexMetadata)cursor.getValue();
                IndexMetadata prevIndexMetadata = previousState.metadata().index(index);
                if (currIndexMetadata.getIndexUUID().equals(prevIndexMetadata.getIndexUUID())) continue;
                created.add(index);
                continue;
            }
            created.add(index);
        }
        return Collections.unmodifiableList(created);
    }
}

