/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.core.TimeValue;

public class ClusterInfoServiceUtils {
    private static final Logger logger = LogManager.getLogger(ClusterInfoServiceUtils.class);

    public static ClusterInfo refresh(InternalClusterInfoService internalClusterInfoService) {
        logger.trace("refreshing cluster info");
        PlainActionFuture<ClusterInfo> future = new PlainActionFuture<ClusterInfo>(){

            protected boolean blockingAllowed() {
                return Thread.currentThread().getName().contains("clusterApplierService#updateTask") || super.blockingAllowed();
            }
        };
        internalClusterInfoService.refreshAsync((ActionListener)future);
        try {
            return (ClusterInfo)future.actionGet(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setUpdateFrequency(InternalClusterInfoService internalClusterInfoService, TimeValue updateFrequency) {
        internalClusterInfoService.setUpdateFrequency(updateFrequency);
    }
}

