/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import shadow.org.elasticsearch.xpack.sql.proto.core.Nullable;

public class IOUtils {
    private IOUtils() {
    }

    public static void close(Exception ex, Iterable<? extends Closeable> objects) throws IOException {
        Exception firstException = ex;
        for (Closeable closeable : objects) {
            try {
                IOUtils.close(closeable);
            }
            catch (IOException | RuntimeException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (RuntimeException)firstException;
        }
    }

    public static void close(Exception e, Closeable ... objects) throws IOException {
        IOUtils.close(e, Arrays.asList(objects));
    }

    public static void close(@Nullable Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        for (Closeable closeable : objects) {
            IOUtils.closeWhileHandlingException(closeable);
        }
    }

    public static void closeWhileHandlingException(Closeable closeable) {
        try {
            IOUtils.close(closeable);
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }
}

