/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;

public class RoleReferenceIntersection {
    private final List<RoleReference> roleReferences;

    public RoleReferenceIntersection(RoleReference ... roleReferences) {
        this(List.of(roleReferences));
    }

    public RoleReferenceIntersection(List<RoleReference> roleReferences) {
        assert (roleReferences != null && !roleReferences.isEmpty()) : "role references cannot be null or empty";
        this.roleReferences = Objects.requireNonNull(roleReferences);
    }

    public List<RoleReference> getRoleReferences() {
        return this.roleReferences;
    }

    public void buildRole(BiConsumer<RoleReference, ActionListener<Role>> singleRoleBuilder, ActionListener<Role> roleActionListener) {
        GroupedActionListener roleGroupedActionListener = new GroupedActionListener(this.roleReferences.size(), roleActionListener.delegateFailureAndWrap((l, roles) -> {
            assert (!roles.isEmpty());
            Iterator iterator = roles.stream().iterator();
            Role finalRole = (Role)iterator.next();
            while (iterator.hasNext()) {
                finalRole = finalRole.limitedBy((Role)iterator.next());
            }
            l.onResponse((Object)finalRole);
        }));
        this.roleReferences.forEach(roleReference -> singleRoleBuilder.accept((RoleReference)roleReference, (ActionListener<Role>)roleGroupedActionListener));
    }
}

