/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RestrictedIndices;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class ClusterPermission {
    public static final ClusterPermission NONE = new ClusterPermission(Set.of(), List.of());
    private final Set<ClusterPrivilege> clusterPrivileges;
    private final List<PermissionCheck> checks;

    private ClusterPermission(Set<ClusterPrivilege> clusterPrivileges, List<PermissionCheck> checks) {
        this.clusterPrivileges = Set.copyOf(clusterPrivileges);
        this.checks = List.copyOf(checks);
    }

    public boolean check(String action, TransportRequest request, Authentication authentication) {
        for (PermissionCheck permission : this.checks) {
            if (!permission.check(action, request, authentication)) continue;
            return true;
        }
        return false;
    }

    public boolean implies(ClusterPermission otherClusterPermission) {
        if (otherClusterPermission.checks.isEmpty()) {
            return true;
        }
        for (PermissionCheck otherPermissionCheck : otherClusterPermission.checks) {
            boolean isImplied = this.checks.stream().anyMatch(thisPermissionCheck -> thisPermissionCheck.implies(otherPermissionCheck));
            if (isImplied) continue;
            return false;
        }
        return true;
    }

    public Set<ClusterPrivilege> privileges() {
        return this.clusterPrivileges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface PermissionCheck {
        public boolean check(String var1, TransportRequest var2, Authentication var3);

        public boolean implies(PermissionCheck var1);
    }

    public static class Builder {
        private final Set<ClusterPrivilege> clusterPrivileges = new HashSet<ClusterPrivilege>();
        private final List<Automaton> actionAutomatons = new ArrayList<Automaton>();
        private final List<PermissionCheck> permissionChecks = new ArrayList<PermissionCheck>();
        private final RestrictedIndices restrictedIndices;

        public Builder(RestrictedIndices restrictedIndices) {
            this.restrictedIndices = restrictedIndices;
        }

        public Builder() {
            this.restrictedIndices = null;
        }

        public Builder add(ClusterPrivilege clusterPrivilege, Set<String> allowedActionPatterns, Set<String> excludeActionPatterns) {
            this.clusterPrivileges.add(clusterPrivilege);
            Automaton actionAutomaton = Builder.createAutomaton(allowedActionPatterns, excludeActionPatterns);
            this.actionAutomatons.add(actionAutomaton);
            return this;
        }

        public Builder add(ClusterPrivilege clusterPrivilege, Set<String> allowedActionPatterns, Predicate<TransportRequest> requestPredicate) {
            Automaton actionAutomaton = Builder.createAutomaton(allowedActionPatterns, Set.of());
            return this.add(clusterPrivilege, new ActionRequestBasedPermissionCheck(clusterPrivilege, actionAutomaton, requestPredicate));
        }

        public Builder add(ClusterPrivilege clusterPrivilege, PermissionCheck permissionCheck) {
            this.clusterPrivileges.add(clusterPrivilege);
            this.permissionChecks.add(permissionCheck);
            return this;
        }

        public Builder addWithPredicateSupplier(ClusterPrivilege clusterPrivilege, Set<String> allowedActionPatterns, Function<RestrictedIndices, Predicate<TransportRequest>> requestPredicateSupplier) {
            Automaton actionAutomaton = Builder.createAutomaton(allowedActionPatterns, Set.of());
            Predicate<TransportRequest> requestPredicate = requestPredicateSupplier.apply(this.restrictedIndices);
            return this.add(clusterPrivilege, new ActionRequestBasedPermissionCheck(clusterPrivilege, actionAutomaton, requestPredicate));
        }

        public ClusterPermission build() {
            if (this.clusterPrivileges.isEmpty()) {
                return NONE;
            }
            List<PermissionCheck> checks = this.permissionChecks;
            if (!this.actionAutomatons.isEmpty()) {
                Automaton mergedAutomaton = Automatons.unionAndMinimize(this.actionAutomatons);
                checks = new ArrayList<PermissionCheck>(this.permissionChecks.size() + 1);
                checks.add(new AutomatonPermissionCheck(mergedAutomaton));
                checks.addAll(this.permissionChecks);
            }
            return new ClusterPermission(this.clusterPrivileges, checks);
        }

        private static Automaton createAutomaton(Set<String> allowedActionPatterns, Set<String> excludeActionPatterns) {
            allowedActionPatterns = allowedActionPatterns == null ? Set.of() : allowedActionPatterns;
            Set<Object> set = excludeActionPatterns = excludeActionPatterns == null ? Set.of() : excludeActionPatterns;
            if (allowedActionPatterns.isEmpty()) {
                return Automatons.EMPTY;
            }
            if (excludeActionPatterns.isEmpty()) {
                return Automatons.patterns(allowedActionPatterns);
            }
            Automaton allowedAutomaton = Automatons.patterns(allowedActionPatterns);
            Automaton excludedAutomaton = Automatons.patterns(excludeActionPatterns);
            return Automatons.minusAndMinimize(allowedAutomaton, excludedAutomaton);
        }
    }

    private static class ActionRequestBasedPermissionCheck
    extends ActionBasedPermissionCheck {
        private final ClusterPrivilege clusterPrivilege;
        private final Predicate<TransportRequest> requestPredicate;

        ActionRequestBasedPermissionCheck(ClusterPrivilege clusterPrivilege, Automaton automaton, Predicate<TransportRequest> requestPredicate) {
            super(automaton);
            this.requestPredicate = requestPredicate;
            this.clusterPrivilege = clusterPrivilege;
        }

        @Override
        protected boolean extendedCheck(String action, TransportRequest request, Authentication authentication) {
            return this.requestPredicate.test(request);
        }

        @Override
        protected boolean doImplies(ActionBasedPermissionCheck permissionCheck) {
            if (permissionCheck instanceof ActionRequestBasedPermissionCheck) {
                ActionRequestBasedPermissionCheck otherCheck = (ActionRequestBasedPermissionCheck)permissionCheck;
                return this.clusterPrivilege.equals(otherCheck.clusterPrivilege);
            }
            return false;
        }
    }

    private static class AutomatonPermissionCheck
    extends ActionBasedPermissionCheck {
        AutomatonPermissionCheck(Automaton automaton) {
            super(automaton);
        }

        @Override
        protected boolean extendedCheck(String action, TransportRequest request, Authentication authentication) {
            return true;
        }

        @Override
        protected boolean doImplies(ActionBasedPermissionCheck permissionCheck) {
            return true;
        }
    }

    public static abstract class ActionBasedPermissionCheck
    implements PermissionCheck {
        private final Automaton automaton;
        private final Predicate<String> actionPredicate;

        public ActionBasedPermissionCheck(Automaton automaton) {
            this.automaton = automaton;
            this.actionPredicate = Automatons.predicate(automaton);
        }

        @Override
        public final boolean check(String action, TransportRequest request, Authentication authentication) {
            return this.actionPredicate.test(action) && this.extendedCheck(action, request, authentication);
        }

        protected abstract boolean extendedCheck(String var1, TransportRequest var2, Authentication var3);

        @Override
        public final boolean implies(PermissionCheck permissionCheck) {
            if (permissionCheck instanceof ActionBasedPermissionCheck) {
                return Automatons.subsetOf(((ActionBasedPermissionCheck)permissionCheck).automaton, this.automaton) && this.doImplies((ActionBasedPermissionCheck)permissionCheck);
            }
            return false;
        }

        protected abstract boolean doImplies(ActionBasedPermissionCheck var1);
    }
}

