/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap.support;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public final class LdapLoadBalancingSettings {
    public static final Function<String, Setting.AffixSetting<String>> LOAD_BALANCE_TYPE_SETTING = RealmSettings.affixSetting("load_balance.type", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final TimeValue CACHE_TTL_DEFAULT = TimeValue.timeValueHours((long)1L);
    public static final Function<String, Setting.AffixSetting<TimeValue>> CACHE_TTL_SETTING = RealmSettings.affixSetting("load_balance.cache_ttl", key -> Setting.timeSetting((String)key, (TimeValue)CACHE_TTL_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    private LdapLoadBalancingSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String realmType) {
        HashSet settings = new HashSet();
        settings.add(LOAD_BALANCE_TYPE_SETTING.apply(realmType));
        settings.add(CACHE_TTL_SETTING.apply(realmType));
        return settings;
    }
}

