/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;

public final class DequeUtils {
    private DequeUtils() {
    }

    public static <T> Deque<T> readDeque(StreamInput in, Writeable.Reader<T> reader) throws IOException {
        return (Deque)in.readCollection(ArrayDeque::new, (stream, deque) -> deque.offer(reader.read(in)));
    }

    public static boolean dequeEquals(Deque<?> thisDeque, Deque<?> otherDeque) {
        if (thisDeque.size() != otherDeque.size()) {
            return false;
        }
        Iterator<?> thisIter = thisDeque.iterator();
        Iterator<?> otherIter = otherDeque.iterator();
        while (thisIter.hasNext() && otherIter.hasNext()) {
            if (thisIter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public static int dequeHashCode(Deque<?> deque) {
        if (deque == null) {
            return 0;
        }
        return deque.stream().reduce(1, (hashCode, chunk) -> 31 * hashCode + (chunk == null ? 0 : chunk.hashCode()), Integer::sum);
    }

    public static <T> Deque<T> of(T elem) {
        ArrayDeque<T> deque = new ArrayDeque<T>(1);
        deque.offer(elem);
        return deque;
    }
}

