/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.threadpool.ThreadPool;

public final class InternalSnapshotsInfoService
implements ClusterStateListener,
SnapshotsInfoService {
    public static final Setting<Integer> INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING = Setting.intSetting("cluster.snapshot.info.max_concurrent_fetches", 5, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(InternalSnapshotsInfoService.class);
    private static final ActionListener<Void> REROUTE_LISTENER = ActionListener.wrap(r -> logger.trace("reroute after snapshot shard size update completed"), e -> logger.debug("reroute after snapshot shard size update failed", (Throwable)e));
    private final ThreadPool threadPool;
    private final RepositoriesService repositoriesService;
    private final Supplier<RerouteService> rerouteService;
    private volatile ImmutableOpenMap<SnapshotShard, Long> knownSnapshotShards;
    private boolean isMaster;
    private final Set<SnapshotShard> unknownSnapshotShards;
    private final Queue<SnapshotShard> queue;
    private final Set<SnapshotShard> failedSnapshotShards;
    private volatile int maxConcurrentFetches;
    private int activeFetches;
    private final Object mutex;

    public InternalSnapshotsInfoService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, Supplier<RerouteService> rerouteServiceSupplier) {
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.repositoriesService = repositoriesService;
        this.rerouteService = rerouteServiceSupplier;
        this.knownSnapshotShards = ImmutableOpenMap.of();
        this.unknownSnapshotShards = new LinkedHashSet<SnapshotShard>();
        this.failedSnapshotShards = new LinkedHashSet<SnapshotShard>();
        this.queue = new ArrayDeque<SnapshotShard>();
        this.mutex = new Object();
        this.activeFetches = 0;
        this.maxConcurrentFetches = INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(INTERNAL_SNAPSHOT_INFO_MAX_CONCURRENT_FETCHES_SETTING, this::setMaxConcurrentFetches);
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(this);
        }
    }

    private void setMaxConcurrentFetches(Integer maxConcurrentFetches) {
        this.maxConcurrentFetches = maxConcurrentFetches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotShardSizeInfo snapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            ImmutableOpenMap.Builder<SnapshotShard, Long> snapshotShardSizes = ImmutableOpenMap.builder(this.knownSnapshotShards);
            if (!this.failedSnapshotShards.isEmpty()) {
                for (SnapshotShard snapshotShard : this.failedSnapshotShards) {
                    Long previous = snapshotShardSizes.put(snapshotShard, -1L);
                    assert (previous == null) : "snapshot shard size already known for " + String.valueOf(snapshotShard);
                }
            }
            return new SnapshotShardSizeInfo(snapshotShardSizes.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            if (event.previousState().nodes().isLocalNodeElectedMaster() && !event.routingTableChanged() && !event.nodesChanged()) {
                return;
            }
            Set<SnapshotShard> onGoingSnapshotRecoveries = InternalSnapshotsInfoService.listOfSnapshotShards(event.state());
            int unknownShards = 0;
            Object object = this.mutex;
            synchronized (object) {
                this.isMaster = true;
                for (SnapshotShard snapshotShard : onGoingSnapshotRecoveries) {
                    if (this.knownSnapshotShards.containsKey(snapshotShard) || this.failedSnapshotShards.contains(snapshotShard) || !this.unknownSnapshotShards.add(snapshotShard)) continue;
                    this.queue.add(snapshotShard);
                    ++unknownShards;
                }
                this.cleanUpSnapshotShardSizes(onGoingSnapshotRecoveries);
            }
            int nbFetchers = Math.min(unknownShards, this.maxConcurrentFetches);
            for (int i = 0; i < nbFetchers; ++i) {
                this.fetchNextSnapshotShard();
            }
        } else if (event.previousState().nodes().isLocalNodeElectedMaster()) {
            Object object = this.mutex;
            synchronized (object) {
                SnapshotShard snapshotShard;
                this.knownSnapshotShards = ImmutableOpenMap.of();
                this.failedSnapshotShards.clear();
                this.isMaster = false;
                while ((snapshotShard = this.queue.poll()) != null) {
                    boolean removed = this.unknownSnapshotShards.remove(snapshotShard);
                    assert (removed) : "snapshot shard to remove does not exist " + String.valueOf(snapshotShard);
                }
                assert (this.invariant());
            }
        } else {
            Object object = this.mutex;
            synchronized (object) {
                assert (this.unknownSnapshotShards.isEmpty() || this.unknownSnapshotShards.size() == this.activeFetches);
                assert (this.knownSnapshotShards.isEmpty());
                assert (this.failedSnapshotShards.isEmpty());
                assert (!this.isMaster);
                assert (this.queue.isEmpty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchNextSnapshotShard() {
        Object object = this.mutex;
        synchronized (object) {
            SnapshotShard snapshotShard;
            if (this.activeFetches < this.maxConcurrentFetches && (snapshotShard = this.queue.poll()) != null) {
                ++this.activeFetches;
                this.threadPool.generic().execute(new FetchingSnapshotShardSizeRunnable(snapshotShard));
            }
            assert (this.invariant());
        }
    }

    private void cleanUpSnapshotShardSizes(Set<SnapshotShard> requiredSnapshotShards) {
        assert (Thread.holdsLock(this.mutex));
        ImmutableOpenMap.Builder<SnapshotShard, Long> newSnapshotShardSizes = null;
        for (SnapshotShard shard : this.knownSnapshotShards.keySet()) {
            if (requiredSnapshotShards.contains(shard)) continue;
            if (newSnapshotShardSizes == null) {
                newSnapshotShardSizes = ImmutableOpenMap.builder(this.knownSnapshotShards);
            }
            newSnapshotShardSizes.remove(shard);
        }
        if (newSnapshotShardSizes != null) {
            this.knownSnapshotShards = newSnapshotShardSizes.build();
        }
        this.failedSnapshotShards.retainAll(requiredSnapshotShards);
    }

    private boolean invariant() {
        assert (Thread.holdsLock(this.mutex));
        assert (this.activeFetches >= 0) : "active fetches should be greater than or equal to zero but got: " + this.activeFetches;
        assert (this.activeFetches <= this.maxConcurrentFetches) : this.activeFetches + " <= " + this.maxConcurrentFetches;
        for (SnapshotShard shard : this.knownSnapshotShards.keySet()) {
            assert (!this.unknownSnapshotShards.contains(shard)) : "cannot be known and unknown at same time: " + String.valueOf(shard);
            assert (!this.failedSnapshotShards.contains(shard)) : "cannot be known and failed at same time: " + String.valueOf(shard);
        }
        for (SnapshotShard shard : this.unknownSnapshotShards) {
            assert (!this.knownSnapshotShards.keySet().contains(shard)) : "cannot be unknown and known at same time: " + String.valueOf(shard);
            assert (!this.failedSnapshotShards.contains(shard)) : "cannot be unknown and failed at same time: " + String.valueOf(shard);
        }
        for (SnapshotShard shard : this.failedSnapshotShards) {
            assert (!this.knownSnapshotShards.keySet().contains(shard)) : "cannot be failed and known at same time: " + String.valueOf(shard);
            assert (!this.unknownSnapshotShards.contains(shard)) : "cannot be failed and unknown at same time: " + String.valueOf(shard);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numberOfUnknownSnapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            return this.unknownSnapshotShards.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numberOfFailedSnapshotShardSizes() {
        Object object = this.mutex;
        synchronized (object) {
            return this.failedSnapshotShards.size();
        }
    }

    int numberOfKnownSnapshotShardSizes() {
        return this.knownSnapshotShards.size();
    }

    private static Set<SnapshotShard> listOfSnapshotShards(ClusterState state) {
        HashSet<SnapshotShard> snapshotShards = new HashSet<SnapshotShard>();
        for (ShardRouting shardRouting : state.getRoutingNodes().unassigned()) {
            if (!shardRouting.primary() || shardRouting.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) continue;
            RecoverySource.SnapshotRecoverySource snapshotRecoverySource = (RecoverySource.SnapshotRecoverySource)shardRouting.recoverySource();
            SnapshotShard snapshotShard = new SnapshotShard(snapshotRecoverySource.snapshot(), snapshotRecoverySource.index(), shardRouting.shardId());
            snapshotShards.add(snapshotShard);
        }
        return Collections.unmodifiableSet(snapshotShards);
    }

    public record SnapshotShard(Snapshot snapshot, IndexId index, ShardId shardId) {
        @Override
        public String toString() {
            return "[snapshot=" + String.valueOf(this.snapshot) + ", index=" + String.valueOf(this.index) + ", shard=" + String.valueOf(this.shardId) + "]";
        }
    }

    private class FetchingSnapshotShardSizeRunnable
    extends AbstractRunnable {
        private final SnapshotShard snapshotShard;
        private boolean removed;

        FetchingSnapshotShardSizeRunnable(SnapshotShard snapshotShard) {
            this.snapshotShard = snapshotShard;
            this.removed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() throws Exception {
            Repository repository = InternalSnapshotsInfoService.this.repositoriesService.repository(this.snapshotShard.snapshot.getRepository());
            logger.debug("fetching snapshot shard size for {}", (Object)this.snapshotShard);
            long snapshotShardSize = repository.getShardSnapshotStatus(this.snapshotShard.snapshot().getSnapshotId(), this.snapshotShard.index(), this.snapshotShard.shardId()).getTotalSize();
            logger.debug("snapshot shard size for {}: {} bytes", (Object)this.snapshotShard, (Object)snapshotShardSize);
            boolean updated = false;
            Object object = InternalSnapshotsInfoService.this.mutex;
            synchronized (object) {
                this.removed = InternalSnapshotsInfoService.this.unknownSnapshotShards.remove(this.snapshotShard);
                assert (this.removed) : "snapshot shard to remove does not exist " + snapshotShardSize;
                if (InternalSnapshotsInfoService.this.isMaster) {
                    ImmutableOpenMap.Builder<SnapshotShard, Long> newSnapshotShardSizes = ImmutableOpenMap.builder(InternalSnapshotsInfoService.this.knownSnapshotShards);
                    boolean bl = updated = newSnapshotShardSizes.put(this.snapshotShard, snapshotShardSize) == null;
                    assert (updated) : "snapshot shard size already exists for " + String.valueOf(this.snapshotShard);
                    InternalSnapshotsInfoService.this.knownSnapshotShards = newSnapshotShardSizes.build();
                }
                --InternalSnapshotsInfoService.this.activeFetches;
                assert (InternalSnapshotsInfoService.this.invariant());
            }
            if (updated) {
                InternalSnapshotsInfoService.this.rerouteService.get().reroute("snapshot shard size updated", Priority.HIGH, REROUTE_LISTENER);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(Exception e) {
            logger.warn(() -> Strings.format((String)"failed to retrieve shard size for %s", (Object[])new Object[]{this.snapshotShard}), (Throwable)e);
            boolean failed = false;
            Object object = InternalSnapshotsInfoService.this.mutex;
            synchronized (object) {
                if (InternalSnapshotsInfoService.this.isMaster) {
                    failed = InternalSnapshotsInfoService.this.failedSnapshotShards.add(this.snapshotShard);
                    assert (failed) : "snapshot shard size already failed for " + String.valueOf(this.snapshotShard);
                }
                if (!this.removed) {
                    InternalSnapshotsInfoService.this.unknownSnapshotShards.remove(this.snapshotShard);
                }
                --InternalSnapshotsInfoService.this.activeFetches;
                assert (InternalSnapshotsInfoService.this.invariant());
            }
            if (failed) {
                InternalSnapshotsInfoService.this.rerouteService.get().reroute("snapshot shard size failed", Priority.HIGH, REROUTE_LISTENER);
            }
        }

        @Override
        public void onAfter() {
            InternalSnapshotsInfoService.this.fetchNextSnapshotShard();
        }
    }
}

