/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramBucket;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalHistogram
extends InternalMultiBucketAggregation<InternalHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final BucketOrder order;
    private final DocValueFormat format;
    private final boolean keyed;
    private final long minDocCount;
    final EmptyBucketInfo emptyBucketInfo;

    public InternalHistogram(String name, List<Bucket> buckets, BucketOrder order, long minDocCount, EmptyBucketInfo emptyBucketInfo, DocValueFormat formatter, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.order = order;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.keyed = keyed;
    }

    public InternalHistogram(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder(in);
        this.minDocCount = in.readVLong();
        this.emptyBucketInfo = this.minDocCount == 0L ? new EmptyBucketInfo(in) : null;
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.buckets = in.readCollectionAsList(stream -> Bucket.readFrom(stream, this.format));
        if (in.getTransportVersion().between(TransportVersions.V_8_13_0, TransportVersions.V_8_14_0)) {
            this.buckets.sort(Comparator.comparingDouble(b -> b.key));
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo.writeTo(out);
        }
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeCollection(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "histogram";
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    long getMinDocCount() {
        return this.minDocCount;
    }

    BucketOrder getOrder() {
        return this.order;
    }

    @Override
    public InternalHistogram create(List<Bucket> buckets) {
        return new InternalHistogram(this.name, buckets, this.order, this.minDocCount, this.emptyBucketInfo, this.format, this.keyed, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, prototype.format, aggregations);
    }

    private List<Bucket> reduceBuckets(PriorityQueue<IteratorAndCurrent<Bucket>> pq, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            double key = ((Bucket)((IteratorAndCurrent)pq.top()).current()).key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if (Double.compare(((Bucket)top.current()).key, key) != 0) {
                    Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    this.maybeAddBucket(reduceContext, reducedBuckets, reduced);
                    currentBuckets.clear();
                    key = ((Bucket)top.current()).key;
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    top.next();
                    assert (Double.compare(((Bucket)top.current()).key, key) > 0) : "shards must return data sorted by key";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                this.maybeAddBucket(reduceContext, reducedBuckets, reduced);
            }
        }
        return reducedBuckets;
    }

    private void maybeAddBucket(AggregationReduceContext reduceContext, List<Bucket> reducedBuckets, Bucket reduced) {
        if (reduced.getDocCount() >= this.minDocCount || !reduceContext.isFinalReduce()) {
            reduceContext.consumeBucketsAndMaybeBreak(1);
            reducedBuckets.add(reduced);
        } else {
            reduceContext.consumeBucketsAndMaybeBreak(-InternalHistogram.countInnerBucket(reduced));
        }
    }

    private Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        try (BucketReducer<Bucket> reducer = new BucketReducer<Bucket>(buckets.get(0), context, buckets.size());){
            for (Bucket bucket : buckets) {
                reducer.accept(bucket);
            }
            Bucket bucket = this.createBucket(reducer.getProto().key, reducer.getDocCount(), reducer.getAggregations());
            return bucket;
        }
    }

    private double nextKey(double key) {
        return this.round(key + this.emptyBucketInfo.interval + this.emptyBucketInfo.interval / 2.0);
    }

    private double round(double key) {
        return Math.floor((key - this.emptyBucketInfo.offset) / this.emptyBucketInfo.interval) * this.emptyBucketInfo.interval + this.emptyBucketInfo.offset;
    }

    private void addEmptyBuckets(List<Bucket> list, final AggregationReduceContext reduceContext) {
        class Counter
        implements DoubleConsumer {
            private int size = 0;

            Counter() {
            }

            @Override
            public void accept(double key) {
                ++this.size;
                if (this.size >= 10000) {
                    reduceContext.consumeBucketsAndMaybeBreak(this.size);
                    this.size = 0;
                }
            }
        }
        Counter counter = new Counter();
        this.iterateEmptyBuckets(list, list.listIterator(), counter);
        reduceContext.consumeBucketsAndMaybeBreak(counter.size);
        final InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(this.emptyBucketInfo.subAggregations, reduceContext);
        final ListIterator<Bucket> iter = list.listIterator();
        this.iterateEmptyBuckets(list, iter, new DoubleConsumer(){
            private int size;

            @Override
            public void accept(double key) {
                ++this.size;
                if (this.size >= 10000) {
                    reduceContext.consumeBucketsAndMaybeBreak(this.size);
                    this.size = 0;
                }
                iter.add(new Bucket(key, 0L, InternalHistogram.this.format, reducedEmptySubAggs));
            }
        });
    }

    private void iterateEmptyBuckets(List<Bucket> list, ListIterator<Bucket> iter, DoubleConsumer onBucket) {
        if (!iter.hasNext()) {
            double key = this.round(this.emptyBucketInfo.minBound);
            while (key <= this.emptyBucketInfo.maxBound) {
                onBucket.accept(key);
                key = this.nextKey(key);
            }
            return;
        }
        Bucket first = list.get(iter.nextIndex());
        if (Double.isFinite(this.emptyBucketInfo.minBound)) {
            double key = this.round(this.emptyBucketInfo.minBound);
            while (key < first.key) {
                onBucket.accept(key);
                key = this.nextKey(key);
            }
        }
        Bucket lastBucket = null;
        do {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                double key = this.nextKey(lastBucket.key);
                while (key < nextBucket.key) {
                    onBucket.accept(key);
                    key = this.nextKey(key);
                }
                assert (key == nextBucket.key || Double.isNaN(nextBucket.key)) : "key: " + key + ", nextBucket.key: " + nextBucket.key;
            }
            lastBucket = iter.next();
        } while (iter.hasNext());
        double key = this.nextKey(lastBucket.key);
        while (key <= this.emptyBucketInfo.maxBound) {
            onBucket.accept(key);
            key = this.nextKey(key);
        }
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            final PriorityQueue<IteratorAndCurrent<Bucket>> pq;
            {
                this.pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(this, size){

                    protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                        return Double.compare(a.current().key, b.current().key) < 0;
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalHistogram histogram = (InternalHistogram)aggregation;
                if (!histogram.buckets.isEmpty()) {
                    this.pq.add(new IteratorAndCurrent<Bucket>(histogram.buckets.iterator()));
                }
            }

            @Override
            public InternalAggregation get() {
                List<Bucket> reducedBuckets = InternalHistogram.this.reduceBuckets(this.pq, reduceContext);
                if (reduceContext.isFinalReduce()) {
                    if (InternalHistogram.this.minDocCount == 0L) {
                        InternalHistogram.this.addEmptyBuckets(reducedBuckets, reduceContext);
                    }
                    if (InternalOrder.isKeyDesc(InternalHistogram.this.order)) {
                        Collections.reverse(reducedBuckets);
                    } else if (!InternalOrder.isKeyAsc(InternalHistogram.this.order)) {
                        CollectionUtil.introSort(reducedBuckets, InternalHistogram.this.order.comparator());
                    }
                }
                return new InternalHistogram(InternalHistogram.this.getName(), reducedBuckets, InternalHistogram.this.order, InternalHistogram.this.minDocCount, InternalHistogram.this.emptyBucketInfo, InternalHistogram.this.format, InternalHistogram.this.keyed, InternalHistogram.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            buckets.add(bucket.finalizeSampling(samplingContext));
        }
        return new InternalHistogram(this.getName(), buckets, this.order, this.minDocCount, this.emptyBucketInfo, this.format, this.keyed, this.getMetadata());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalHistogram(this.name, buckets2, this.order, this.minDocCount, this.emptyBucketInfo, this.format, this.keyed, this.getMetadata());
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.doubleValue(), docCount, this.format, aggregations);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalHistogram that = (InternalHistogram)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.emptyBucketInfo, that.emptyBucketInfo) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.order, that.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.emptyBucketInfo, this.format, this.keyed, this.minDocCount, this.order);
    }

    public static class EmptyBucketInfo {
        final double interval;
        final double offset;
        final double minBound;
        final double maxBound;
        final InternalAggregations subAggregations;

        public EmptyBucketInfo(double interval, double offset, double minBound, double maxBound, InternalAggregations subAggregations) {
            this.interval = interval;
            this.offset = offset;
            this.minBound = minBound;
            this.maxBound = maxBound;
            this.subAggregations = subAggregations;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), InternalAggregations.readFrom(in));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.interval);
            out.writeDouble(this.offset);
            out.writeDouble(this.minBound);
            out.writeDouble(this.maxBound);
            this.subAggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyBucketInfo that = (EmptyBucketInfo)obj;
            return this.interval == that.interval && this.offset == that.offset && this.minBound == that.minBound && this.maxBound == that.maxBound && Objects.equals(this.subAggregations, that.subAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.interval, this.offset, this.minBound, this.maxBound, this.subAggregations);
        }
    }

    public static class Bucket
    extends AbstractHistogramBucket
    implements KeyComparable<Bucket> {
        final double key;

        public Bucket(double key, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            super(docCount, aggregations, format);
            this.key = key;
        }

        public static Bucket readFrom(StreamInput in, DocValueFormat format) throws IOException {
            return new Bucket(in.readDouble(), in.readVLong(), format, InternalAggregations.readFrom(in));
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return this.key == that.key && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.docCount, this.aggregations);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.key).toString();
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            String keyAsString = this.format.format(this.key).toString();
            if (keyed) {
                builder.startObject(keyAsString);
            } else {
                builder.startObject();
            }
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        @Override
        public int compareKey(Bucket other) {
            return Double.compare(this.key, other.key);
        }

        Bucket finalizeSampling(SamplingContext samplingContext) {
            return new Bucket(this.key, samplingContext.scaleUp(this.docCount), this.format, InternalAggregations.finalizeSampling(this.aggregations, samplingContext));
        }
    }
}

