/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public interface TokenFilterFactory {
    public static final TokenFilterFactory IDENTITY_FILTER = new TokenFilterFactory(){

        @Override
        public String name() {
            return "identity";
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return tokenStream;
        }
    };

    public String name();

    public TokenStream create(TokenStream var1);

    default public TokenStream normalize(TokenStream tokenStream) {
        return tokenStream;
    }

    default public boolean breaksFastVectorHighlighter() {
        return false;
    }

    default public TokenFilterFactory getChainAwareTokenFilterFactory(IndexService.IndexCreationContext context, TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        return this;
    }

    default public TokenFilterFactory getSynonymFilter() {
        return this;
    }

    default public AnalysisMode getAnalysisMode() {
        return AnalysisMode.ALL;
    }

    default public String getResourceName() {
        return null;
    }
}

