/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.time.Instant;
import java.util.concurrent.locks.StampedLock;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class RotatableSecret {
    private Secrets secrets;
    private final StampedLock stampedLock = new StampedLock();

    public RotatableSecret(@Nullable SecureString secret) {
        this.secrets = new Secrets(Strings.hasText(secret) ? secret.clone() : null, null, Instant.EPOCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(SecureString newSecret, TimeValue gracePeriod) {
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.secrets.current == null || !this.secrets.current.equals(newSecret)) {
                this.secrets = new Secrets(Strings.hasText(newSecret) ? newSecret.clone() : null, this.secrets.current, Instant.now().plusMillis(gracePeriod.getMillis()));
            }
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    public boolean isSet() {
        this.checkExpired();
        return Strings.hasText(this.secrets.current) || Strings.hasText(this.secrets.prior);
    }

    public boolean matches(SecureString secret) {
        this.checkExpired();
        if (!Strings.hasText(secret)) {
            return false;
        }
        boolean currentSecretValid = Strings.hasText(this.secrets.current);
        boolean priorSecretValid = Strings.hasText(this.secrets.prior);
        if (currentSecretValid && this.secrets.current.equals(secret)) {
            return true;
        }
        return priorSecretValid && this.secrets.prior.equals(secret);
    }

    Secrets getSecrets() {
        return this.secrets;
    }

    boolean isWriteLocked() {
        return this.stampedLock.isWriteLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired() {
        boolean expired;
        boolean needToUnlock = false;
        long stamp = this.stampedLock.tryOptimisticRead();
        boolean bl = expired = this.secrets.prior != null && this.secrets.priorValidTill.compareTo(Instant.now()) <= 0;
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.readLock();
            needToUnlock = true;
            expired = this.secrets.prior != null && this.secrets.priorValidTill.compareTo(Instant.now()) <= 0;
        }
        try {
            if (expired) {
                long stampUpgrade = this.stampedLock.tryConvertToWriteLock(stamp);
                if (stampUpgrade == 0L) {
                    if (needToUnlock) {
                        this.stampedLock.unlockRead(stamp);
                    }
                    stamp = this.stampedLock.writeLock();
                    expired = this.secrets.prior != null && this.secrets.priorValidTill.isBefore(Instant.now());
                } else {
                    stamp = stampUpgrade;
                }
                needToUnlock = true;
                if (expired) {
                    SecureString prior = this.secrets.prior;
                    this.secrets = new Secrets(this.secrets.current, null, Instant.EPOCH);
                    prior.close();
                }
            }
        }
        finally {
            if (needToUnlock) {
                this.stampedLock.unlock(stamp);
            }
        }
    }

    public record Secrets(SecureString current, SecureString prior, Instant priorValidTill) {
    }
}

