/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;

public final class OptionalBytesReference {
    public static final OptionalBytesReference MISSING = new OptionalBytesReference(null);
    public static final OptionalBytesReference EMPTY = new OptionalBytesReference(BytesArray.EMPTY);
    private final BytesReference bytesReference;

    private OptionalBytesReference(BytesReference bytesReference) {
        this.bytesReference = bytesReference;
    }

    public static OptionalBytesReference of(BytesReference bytesReference) {
        if (bytesReference.length() == 0) {
            return EMPTY;
        }
        return new OptionalBytesReference(bytesReference);
    }

    public boolean isPresent() {
        return this.bytesReference != null;
    }

    public BytesReference bytesReference() {
        if (this.bytesReference == null) {
            assert (false) : "missing";
            throw new IllegalStateException("cannot get bytesReference() on OptionalBytesReference#MISSING");
        }
        return this.bytesReference;
    }

    public String toString() {
        if (this.bytesReference == null) {
            return "OptionalBytesReference[MISSING]";
        }
        StringBuilder stringBuilder = new StringBuilder("OptionalBytesReference[");
        BytesRefIterator iterator = this.bytesReference.iterator();
        boolean first = true;
        try {
            BytesRef bytesRef;
            while ((bytesRef = iterator.next()) != null) {
                for (int i = 0; i < bytesRef.length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(Strings.format("%02x", bytesRef.bytes[bytesRef.offset + i]));
                }
            }
            return stringBuilder.append(']').toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

