/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import org.elasticsearch.common.Strings;

public enum OperationPurpose {
    SNAPSHOT_DATA("SnapshotData"),
    SNAPSHOT_METADATA("SnapshotMetadata"),
    REPOSITORY_ANALYSIS("RepositoryAnalysis"),
    CLUSTER_STATE("ClusterState"),
    INDICES("Indices"),
    TRANSLOG("Translog");

    private final String key;

    private OperationPurpose(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static OperationPurpose parse(String s) {
        for (OperationPurpose purpose : OperationPurpose.values()) {
            if (!purpose.key.equals(s)) continue;
            return purpose;
        }
        throw new IllegalArgumentException(Strings.format("invalid purpose [%s] expected one of [%s]", s, Strings.arrayToCommaDelimitedString((Object[])OperationPurpose.values())));
    }
}

