/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;

public interface ClusterStateTaskExecutor<T extends ClusterStateTaskListener> {
    public ClusterState execute(BatchExecutionContext<T> var1) throws Exception;

    default public boolean runOnlyOnMaster() {
        return true;
    }

    default public void clusterStatePublished(ClusterState newClusterState) {
    }

    default public String describeTasks(List<T> tasks) {
        StringBuilder output = new StringBuilder();
        Strings.collectionToDelimitedStringWithLimit(() -> tasks.stream().map(Object::toString).filter(s -> !s.isEmpty()).iterator(), ", ", 1024, output);
        return output.toString();
    }

    public record BatchExecutionContext<T extends ClusterStateTaskListener>(ClusterState initialState, List<? extends TaskContext<T>> taskContexts, Supplier<Releasable> dropHeadersContextSupplier) {
        public Releasable dropHeadersContext() {
            return this.dropHeadersContextSupplier.get();
        }
    }

    public static interface TaskContext<T extends ClusterStateTaskListener> {
        public T getTask();

        public void success(Runnable var1);

        @Deprecated
        public void success(Consumer<ClusterState> var1);

        public void success(Runnable var1, ClusterStateAckListener var2);

        @Deprecated
        public void success(Consumer<ClusterState> var1, ClusterStateAckListener var2);

        default public void success(ClusterStateAckListener clusterStateAckListener) {
            this.success(() -> {}, clusterStateAckListener);
        }

        public void onFailure(Exception var1);

        public Releasable captureResponseHeaders();
    }
}

