/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.transport.RemoteClusterService;

public class ResolvedIndices {
    @Nullable
    private final SearchContextId searchContextId;
    private final Map<String, OriginalIndices> remoteClusterIndices;
    @Nullable
    private final OriginalIndices localIndices;
    private final Map<Index, IndexMetadata> localIndexMetadata;

    ResolvedIndices(Map<String, OriginalIndices> remoteClusterIndices, @Nullable OriginalIndices localIndices, Map<Index, IndexMetadata> localIndexMetadata, @Nullable SearchContextId searchContextId) {
        this.remoteClusterIndices = Collections.unmodifiableMap(remoteClusterIndices);
        this.localIndices = localIndices;
        this.localIndexMetadata = Collections.unmodifiableMap(localIndexMetadata);
        this.searchContextId = searchContextId;
    }

    ResolvedIndices(Map<String, OriginalIndices> remoteClusterIndices, @Nullable OriginalIndices localIndices, Map<Index, IndexMetadata> localIndexMetadata) {
        this(remoteClusterIndices, localIndices, localIndexMetadata, null);
    }

    public Map<String, OriginalIndices> getRemoteClusterIndices() {
        return this.remoteClusterIndices;
    }

    @Nullable
    public OriginalIndices getLocalIndices() {
        return this.localIndices;
    }

    public Map<Index, IndexMetadata> getConcreteLocalIndicesMetadata() {
        return this.localIndexMetadata;
    }

    public Index[] getConcreteLocalIndices() {
        return (Index[])this.localIndexMetadata.keySet().toArray(Index[]::new);
    }

    @Nullable
    public SearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public static ResolvedIndices resolveWithIndicesRequest(IndicesRequest request, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, long startTimeInMillis) {
        return ResolvedIndices.resolveWithIndexNamesAndOptions(request.indices(), request.indicesOptions(), clusterState, indexNameExpressionResolver, remoteClusterService, startTimeInMillis);
    }

    public static ResolvedIndices resolveWithIndexNamesAndOptions(String[] indexNames, IndicesOptions indicesOptions, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver, RemoteClusterService remoteClusterService, long startTimeInMillis) {
        Map<String, OriginalIndices> remoteClusterIndices = remoteClusterService.groupIndices(indicesOptions, indexNames);
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        Index[] concreteLocalIndices = localIndices == null ? Index.EMPTY_ARRAY : indexNameExpressionResolver.concreteIndices(clusterState, localIndices, startTimeInMillis);
        return new ResolvedIndices(remoteClusterIndices, localIndices, ResolvedIndices.resolveLocalIndexMetadata(concreteLocalIndices, clusterState, true));
    }

    public static ResolvedIndices resolveWithPIT(PointInTimeBuilder pit, IndicesOptions indicesOptions, ClusterState clusterState, NamedWriteableRegistry namedWriteableRegistry) {
        OriginalIndices localIndices;
        Index[] concreteLocalIndices;
        SearchContextId searchContextId = pit.getSearchContextId(namedWriteableRegistry);
        HashMap<String, Set> indicesFromSearchContext = new HashMap<String, Set>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContextId.shards().entrySet()) {
            String clusterAlias = entry.getValue().getClusterAlias();
            if (clusterAlias == null) {
                clusterAlias = "";
            }
            indicesFromSearchContext.computeIfAbsent(clusterAlias, s -> new HashSet()).add(entry.getKey().getIndex());
        }
        Set localIndicesSet = (Set)indicesFromSearchContext.remove("");
        if (localIndicesSet != null) {
            concreteLocalIndices = (Index[])localIndicesSet.toArray(Index[]::new);
            localIndices = new OriginalIndices((String[])localIndicesSet.stream().map(Index::getName).toArray(String[]::new), indicesOptions);
        } else {
            concreteLocalIndices = Index.EMPTY_ARRAY;
            localIndices = null;
        }
        HashMap<String, OriginalIndices> remoteClusterIndices = new HashMap<String, OriginalIndices>();
        for (Map.Entry entry : indicesFromSearchContext.entrySet()) {
            OriginalIndices originalIndices = new OriginalIndices((String[])((Set)entry.getValue()).stream().map(Index::getName).toArray(String[]::new), indicesOptions);
            remoteClusterIndices.put((String)entry.getKey(), originalIndices);
        }
        return new ResolvedIndices(remoteClusterIndices, localIndices, ResolvedIndices.resolveLocalIndexMetadata(concreteLocalIndices, clusterState, false), searchContextId);
    }

    private static Map<Index, IndexMetadata> resolveLocalIndexMetadata(Index[] concreteLocalIndices, ClusterState clusterState, boolean failOnMissingIndex) {
        HashMap<Index, IndexMetadata> localIndexMetadata = new HashMap<Index, IndexMetadata>();
        for (Index index : concreteLocalIndices) {
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            if (indexMetadata == null) {
                if (!failOnMissingIndex) continue;
                throw new IndexNotFoundException(index);
            }
            localIndexMetadata.put(index, indexMetadata);
        }
        return localIndexMetadata;
    }
}

