/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Releasable;

public final class LocalCircuitBreaker
implements CircuitBreaker,
Releasable {
    private final CircuitBreaker breaker;
    private final long overReservedBytes;
    private final long maxOverReservedBytes;
    private long reservedBytes;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LocalCircuitBreaker(CircuitBreaker breaker, long overReservedBytes, long maxOverReservedBytes) {
        this.breaker = breaker;
        this.maxOverReservedBytes = maxOverReservedBytes;
        this.overReservedBytes = Math.min(overReservedBytes, maxOverReservedBytes);
    }

    public void circuitBreak(String fieldName, long bytesNeeded) {
        this.breaker.circuitBreak(fieldName, bytesNeeded);
    }

    public void addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        if (bytes <= this.reservedBytes) {
            this.reservedBytes -= bytes;
            this.maybeReduceReservedBytes();
        } else {
            this.breaker.addEstimateBytesAndMaybeBreak(bytes - this.reservedBytes + this.overReservedBytes, label);
            this.reservedBytes = this.overReservedBytes;
        }
    }

    public void addWithoutBreaking(long bytes) {
        if (bytes <= this.reservedBytes) {
            this.reservedBytes -= bytes;
            this.maybeReduceReservedBytes();
        } else {
            this.breaker.addWithoutBreaking(bytes);
        }
    }

    private void maybeReduceReservedBytes() {
        if (this.reservedBytes > this.maxOverReservedBytes) {
            this.breaker.addWithoutBreaking(this.maxOverReservedBytes - this.reservedBytes);
            this.reservedBytes = this.maxOverReservedBytes;
        }
    }

    public CircuitBreaker parentBreaker() {
        return this.breaker;
    }

    public long getUsed() {
        return this.breaker.getUsed();
    }

    long getReservedBytes() {
        return this.reservedBytes;
    }

    public long getLimit() {
        return this.breaker.getLimit();
    }

    public double getOverhead() {
        return this.breaker.getOverhead();
    }

    public long getTrippedCount() {
        return this.breaker.getTrippedCount();
    }

    public String getName() {
        return this.breaker.getName();
    }

    public CircuitBreaker.Durability getDurability() {
        return this.breaker.getDurability();
    }

    public void setLimitAndOverhead(long limit, double overhead) {
        this.breaker.setLimitAndOverhead(limit, overhead);
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.breaker.addWithoutBreaking(-this.reservedBytes);
        }
    }

    public String toString() {
        return "LocalCircuitBreaker[" + this.reservedBytes + "/" + this.overReservedBytes + ":" + this.maxOverReservedBytes + "]";
    }

    public record SizeSettings(long overReservedBytes, long maxOverReservedBytes) {
        public SizeSettings(Settings settings) {
            this(settings.getAsBytesSize("esql.block_factory.local_breaker.over_reserved", BlockFactory.LOCAL_BREAKER_OVER_RESERVED_DEFAULT_SIZE).getBytes(), settings.getAsBytesSize("esql.block_factory.local_breaker.max_over_reserved", BlockFactory.LOCAL_BREAKER_OVER_RESERVED_DEFAULT_MAX_SIZE).getBytes());
        }
    }
}

