/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DocBlock;

public enum ElementType {
    BOOLEAN("Boolean", BlockFactory::newBooleanBlockBuilder),
    INT("Int", BlockFactory::newIntBlockBuilder),
    LONG("Long", BlockFactory::newLongBlockBuilder),
    FLOAT("Float", BlockFactory::newFloatBlockBuilder),
    DOUBLE("Double", BlockFactory::newDoubleBlockBuilder),
    NULL("Null", (blockFactory, estimatedSize) -> new ConstantNullBlock.Builder(blockFactory)),
    BYTES_REF("BytesRef", BlockFactory::newBytesRefBlockBuilder),
    DOC("Doc", DocBlock::newBlockBuilder),
    COMPOSITE("Composite", BlockFactory::newAggregateMetricDoubleBlockBuilder),
    UNKNOWN("Unknown", (blockFactory, estimatedSize) -> {
        throw new UnsupportedOperationException("can't build null blocks");
    });

    private final String pascalCaseName;
    private final BuilderSupplier builder;

    private ElementType(String pascalCaseName, BuilderSupplier builder) {
        this.pascalCaseName = pascalCaseName;
        this.builder = builder;
    }

    public Block.Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return this.builder.newBlockBuilder(blockFactory, estimatedSize);
    }

    public static ElementType fromJava(Class<?> type) {
        ElementType elementType;
        if (type == Integer.class) {
            elementType = INT;
        } else if (type == Long.class) {
            elementType = LONG;
        } else if (type == Float.class) {
            elementType = FLOAT;
        } else if (type == Double.class) {
            elementType = DOUBLE;
        } else if (type == String.class || type == BytesRef.class) {
            elementType = BYTES_REF;
        } else if (type == Boolean.class) {
            elementType = BOOLEAN;
        } else if (type == AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral.class) {
            elementType = COMPOSITE;
        } else if (type == null || type == Void.class) {
            elementType = NULL;
        } else {
            throw new IllegalArgumentException("Unrecognized class type " + String.valueOf(type));
        }
        return elementType;
    }

    public String pascalCaseName() {
        return this.pascalCaseName;
    }

    private static interface BuilderSupplier {
        public Block.Builder newBlockBuilder(BlockFactory var1, int var2);
    }
}

