/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class ParameterizableYamlXContentParser
implements XContentParser {
    private final XContentParser delegate;
    private final Map<String, ?> params;

    public ParameterizableYamlXContentParser(XContentParser delegate, Map<String, ?> params) {
        this.delegate = delegate;
        this.params = params.entrySet().stream().collect(Collectors.toMap(e -> "@" + (String)e.getKey() + "@", Map.Entry::getValue));
    }

    public XContentType contentType() {
        return this.delegate.contentType();
    }

    public void allowDuplicateKeys(boolean allowDuplicateKeys) {
        this.delegate.allowDuplicateKeys(allowDuplicateKeys);
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.delegate.nextToken();
    }

    @Nullable
    public String nextFieldName() throws IOException {
        return this.delegate.nextFieldName();
    }

    public void skipChildren() throws IOException {
        this.delegate.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.delegate.currentToken();
    }

    public String currentName() throws IOException {
        return this.delegate.currentName();
    }

    public Map<String, Object> map() throws IOException {
        return this.delegate.map();
    }

    public Map<String, Object> mapOrdered() throws IOException {
        return this.visitMapForParameterReplacements(this.delegate.mapOrdered());
    }

    private Map<String, Object> visitMapForParameterReplacements(Map<String, Object> stringObjectMap) {
        Map<String, Object> updatedMap = stringObjectMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.maybeReplaceParams(e.getValue())));
        return updatedMap;
    }

    private Object maybeReplaceParams(Object inputValue) {
        if (inputValue == null) {
            return null;
        }
        if (inputValue instanceof Map) {
            return this.visitMapForParameterReplacements((Map)inputValue);
        }
        if (inputValue instanceof String && ((String)inputValue).matches(".*@.*@.*")) {
            String value = (String)inputValue;
            for (String s : this.params.keySet()) {
                if (!value.contains(s)) continue;
                value = value.replace(s, this.params.get(s).toString());
            }
            return value;
        }
        return inputValue;
    }

    public Map<String, String> mapStrings() throws IOException {
        return this.delegate.mapStrings();
    }

    public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
        return this.delegate.map(mapFactory, mapValueParser);
    }

    public List<Object> list() throws IOException {
        return this.delegate.list();
    }

    public List<Object> listOrderedMap() throws IOException {
        return this.delegate.listOrderedMap();
    }

    public String text() throws IOException {
        return this.delegate.text();
    }

    public String textOrNull() throws IOException {
        return this.delegate.textOrNull();
    }

    public CharBuffer charBufferOrNull() throws IOException {
        return this.delegate.charBufferOrNull();
    }

    public CharBuffer charBuffer() throws IOException {
        return this.delegate.charBuffer();
    }

    public Object objectText() throws IOException {
        return this.delegate.objectText();
    }

    public Object objectBytes() throws IOException {
        return this.delegate.objectBytes();
    }

    public boolean hasTextCharacters() {
        return this.delegate.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.delegate.textCharacters();
    }

    public int textLength() throws IOException {
        return this.delegate.textLength();
    }

    public int textOffset() throws IOException {
        return this.delegate.textOffset();
    }

    public Number numberValue() throws IOException {
        return this.delegate.numberValue();
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.delegate.numberType();
    }

    public short shortValue(boolean coerce) throws IOException {
        return this.delegate.shortValue(coerce);
    }

    public int intValue(boolean coerce) throws IOException {
        return this.delegate.intValue(coerce);
    }

    public long longValue(boolean coerce) throws IOException {
        return this.delegate.longValue(coerce);
    }

    public float floatValue(boolean coerce) throws IOException {
        return this.delegate.floatValue(coerce);
    }

    public double doubleValue(boolean coerce) throws IOException {
        return this.delegate.doubleValue(coerce);
    }

    public short shortValue() throws IOException {
        return this.delegate.shortValue();
    }

    public int intValue() throws IOException {
        return this.delegate.intValue();
    }

    public long longValue() throws IOException {
        return this.delegate.longValue();
    }

    public float floatValue() throws IOException {
        return this.delegate.floatValue();
    }

    public double doubleValue() throws IOException {
        return this.delegate.doubleValue();
    }

    public boolean isBooleanValue() throws IOException {
        return this.delegate.isBooleanValue();
    }

    public boolean booleanValue() throws IOException {
        return this.delegate.booleanValue();
    }

    public byte[] binaryValue() throws IOException {
        return this.delegate.binaryValue();
    }

    public XContentLocation getTokenLocation() {
        return this.delegate.getTokenLocation();
    }

    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return (T)this.getXContentRegistry().parseNamedObject(categoryClass, name, (XContentParser)this, context);
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.delegate.getXContentRegistry();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public RestApiVersion getRestApiVersion() {
        return this.delegate.getRestApiVersion();
    }

    public DeprecationHandler getDeprecationHandler() {
        return this.delegate.getDeprecationHandler();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

