/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.results;

import java.io.IOException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.inference.pytorch.results.AckResult;
import org.elasticsearch.xpack.ml.inference.pytorch.results.ErrorResult;
import org.elasticsearch.xpack.ml.inference.pytorch.results.PyTorchInferenceResult;
import org.elasticsearch.xpack.ml.inference.pytorch.results.ThreadSettings;

public record PyTorchResult(String requestId, Boolean isCacheHit, Long timeMs, @Nullable PyTorchInferenceResult inferenceResult, @Nullable ThreadSettings threadSettings, @Nullable AckResult ackResult, @Nullable ErrorResult errorResult) implements ToXContentObject
{
    private static final ParseField REQUEST_ID = new ParseField("request_id", new String[0]);
    private static final ParseField CACHE_HIT = new ParseField("cache_hit", new String[0]);
    private static final ParseField TIME_MS = new ParseField("time_ms", new String[0]);
    private static final ParseField RESULT = new ParseField("result", new String[0]);
    private static final ParseField THREAD_SETTINGS = new ParseField("thread_settings", new String[0]);
    private static final ParseField ACK = new ParseField("ack", new String[0]);
    public static final ConstructingObjectParser<PyTorchResult, Void> PARSER = new ConstructingObjectParser("pytorch_result", a -> new PyTorchResult((String)a[0], (Boolean)a[1], (Long)a[2], (PyTorchInferenceResult)a[3], (ThreadSettings)a[4], (AckResult)a[5], (ErrorResult)a[6]));

    public boolean isError() {
        return this.errorResult != null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.requestId != null) {
            builder.field(REQUEST_ID.getPreferredName(), this.requestId);
        }
        if (this.isCacheHit != null) {
            builder.field(CACHE_HIT.getPreferredName(), this.isCacheHit);
        }
        if (this.timeMs != null) {
            builder.field(TIME_MS.getPreferredName(), this.timeMs);
        }
        if (this.inferenceResult != null) {
            builder.field(RESULT.getPreferredName(), (ToXContent)this.inferenceResult);
        }
        if (this.threadSettings != null) {
            builder.field(THREAD_SETTINGS.getPreferredName(), (ToXContent)this.threadSettings);
        }
        if (this.ackResult != null) {
            builder.field(ACK.getPreferredName(), (ToXContent)this.ackResult);
        }
        if (this.errorResult != null) {
            builder.field(ErrorResult.ERROR.getPreferredName(), (ToXContent)this.errorResult);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REQUEST_ID);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CACHE_HIT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_MS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PyTorchInferenceResult.PARSER, RESULT);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ThreadSettings.PARSER, THREAD_SETTINGS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), AckResult.PARSER, ACK);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ErrorResult.PARSER, ErrorResult.ERROR);
    }
}

