/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.deployment;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;
import org.elasticsearch.xpack.ml.job.process.AbstractInitializableRunnable;

abstract class AbstractPyTorchAction<T>
extends AbstractInitializableRunnable {
    private final String deploymentId;
    private final long requestId;
    private final TimeValue timeout;
    private Scheduler.Cancellable timeoutHandler;
    private final DeploymentManager.ProcessContext processContext;
    private final AtomicBoolean notified = new AtomicBoolean();
    private final ActionListener<T> listener;
    private final ThreadPool threadPool;

    protected AbstractPyTorchAction(String deploymentId, long requestId, TimeValue timeout, DeploymentManager.ProcessContext processContext, ThreadPool threadPool, ActionListener<T> listener) {
        this.deploymentId = (String)ExceptionsHelper.requireNonNull((Object)deploymentId, (String)"deploymentId");
        this.requestId = requestId;
        this.timeout = (TimeValue)ExceptionsHelper.requireNonNull((Object)timeout, (String)"timeout");
        this.processContext = (DeploymentManager.ProcessContext)ExceptionsHelper.requireNonNull((Object)processContext, (String)"processContext");
        this.listener = (ActionListener)ExceptionsHelper.requireNonNull(listener, (String)"listener");
        this.threadPool = (ThreadPool)ExceptionsHelper.requireNonNull((Object)threadPool, (String)"threadPool");
    }

    @Override
    public final void init() {
        if (this.timeoutHandler == null) {
            this.timeoutHandler = this.threadPool.schedule(this::onTimeout, this.timeout, (Executor)this.threadPool.executor("ml_utility"));
        }
    }

    void onTimeout() {
        this.onTimeout((Exception)((Object)new ElasticsearchStatusException("timeout [{}] waiting for inference result", RestStatus.REQUEST_TIMEOUT, new Object[]{this.timeout})));
    }

    void onCancel() {
        this.onTimeout((Exception)((Object)new ElasticsearchStatusException("inference task cancelled", RestStatus.BAD_REQUEST, new Object[0])));
    }

    void onTimeout(Exception e) {
        if (this.notified.compareAndSet(false, true)) {
            this.processContext.getTimeoutCount().incrementAndGet();
            this.processContext.getResultProcessor().ignoreResponseWithoutNotifying(String.valueOf(this.requestId));
            this.listener.onFailure(e);
            return;
        }
        this.getLogger().debug("[{}] request [{}] received timeout after [{}] but listener already alerted", (Object)this.deploymentId, (Object)this.requestId, (Object)this.timeout);
    }

    void onSuccess(T result) {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.cancel();
        } else assert (false) : "init() not called, timeout handler unexpectedly null";
        if (this.notified.compareAndSet(false, true)) {
            this.listener.onResponse(result);
            return;
        }
        this.getLogger().debug("[{}] request [{}] received inference response but listener already notified", (Object)this.deploymentId, (Object)this.requestId);
    }

    public void onRejection(Exception e) {
        super.onRejection(e);
        this.processContext.getRejectedExecutionCount().incrementAndGet();
    }

    public void onFailure(Exception e) {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.cancel();
        } else assert (false) : "init() not called, timeout handler unexpectedly null";
        if (this.notified.compareAndSet(false, true)) {
            this.processContext.getResultProcessor().ignoreResponseWithoutNotifying(String.valueOf(this.requestId));
            this.listener.onFailure(e);
            return;
        }
        this.getLogger().debug(() -> Strings.format((String)"[%s] request [%s] received failure but listener already notified", (Object[])new Object[]{this.deploymentId, this.requestId}), (Throwable)e);
    }

    protected void onFailure(String errorMessage) {
        this.onFailure((Exception)((Object)new ElasticsearchStatusException("Error in inference process: [" + errorMessage + "]", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
    }

    boolean isNotified() {
        return this.notified.get();
    }

    long getRequestId() {
        return this.requestId;
    }

    String getDeploymentId() {
        return this.deploymentId;
    }

    DeploymentManager.ProcessContext getProcessContext() {
        return this.processContext;
    }

    TimeValue getTimeout() {
        return this.timeout;
    }

    protected abstract Logger getLogger();
}

