/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContext;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.RestartTimeInfo;

public class DatafeedContextProvider {
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider resultsProvider;

    public DatafeedContextProvider(JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider) {
        this.jobConfigProvider = Objects.requireNonNull(jobConfigProvider);
        this.datafeedConfigProvider = Objects.requireNonNull(datafeedConfigProvider);
        this.resultsProvider = Objects.requireNonNull(jobResultsProvider);
    }

    public void buildDatafeedContext(String datafeedId, ActionListener<DatafeedContext> listener) {
        this.datafeedConfigProvider.getDatafeedConfig(datafeedId, null, (ActionListener<DatafeedConfig.Builder>)listener.delegateFailureAndWrap((delegate1, datafeedConfigBuilder) -> {
            DatafeedConfig datafeedConfig = datafeedConfigBuilder.build();
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), null, (ActionListener<Job.Builder>)delegate1.delegateFailureAndWrap((delegate2, jobBuilder) -> this.resultsProvider.getRestartTimeInfo(jobBuilder.getId(), (ActionListener<RestartTimeInfo>)delegate2.delegateFailureAndWrap((delegate3, restartTimeInfo) -> this.resultsProvider.datafeedTimingStats(jobBuilder.getId(), timingStats -> delegate3.onResponse((Object)new DatafeedContext(datafeedConfig, jobBuilder.build(), (RestartTimeInfo)restartTimeInfo, (DatafeedTimingStats)timingStats)), arg_0 -> ((ActionListener)delegate3).onFailure(arg_0))))));
        }));
    }
}

