/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.autoscaling.MlMemoryAutoscalingCapacity;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class NativeMemoryCapacity {
    static final NativeMemoryCapacity ZERO = new NativeMemoryCapacity(0L, 0L);
    private static final Logger logger = LogManager.getLogger(NativeMemoryCapacity.class);
    private final long tierMlNativeMemoryRequirementExcludingOverhead;
    private final long nodeMlNativeMemoryRequirementExcludingOverhead;
    private final Long jvmSize;

    public NativeMemoryCapacity(long tierMlNativeMemoryRequirementExcludingOverhead, long nodeMlNativeMemoryRequirementExcludingOverhead, Long jvmSize) {
        this.tierMlNativeMemoryRequirementExcludingOverhead = tierMlNativeMemoryRequirementExcludingOverhead;
        this.nodeMlNativeMemoryRequirementExcludingOverhead = nodeMlNativeMemoryRequirementExcludingOverhead;
        this.jvmSize = jvmSize;
    }

    NativeMemoryCapacity(long tierMlNativeMemoryRequirementExcludingOverhead, long nodeMlNativeMemoryRequirementExcludingOverhead) {
        this(tierMlNativeMemoryRequirementExcludingOverhead, nodeMlNativeMemoryRequirementExcludingOverhead, null);
    }

    NativeMemoryCapacity merge(NativeMemoryCapacity nativeMemoryCapacity) {
        if (this == nativeMemoryCapacity) {
            return this;
        }
        if (nativeMemoryCapacity.nodeMlNativeMemoryRequirementExcludingOverhead == 0L && nativeMemoryCapacity.tierMlNativeMemoryRequirementExcludingOverhead == 0L) {
            return this;
        }
        if (this.nodeMlNativeMemoryRequirementExcludingOverhead == 0L && this.tierMlNativeMemoryRequirementExcludingOverhead == 0L) {
            return nativeMemoryCapacity;
        }
        long tier = this.tierMlNativeMemoryRequirementExcludingOverhead + nativeMemoryCapacity.tierMlNativeMemoryRequirementExcludingOverhead;
        long node = Math.max(nativeMemoryCapacity.nodeMlNativeMemoryRequirementExcludingOverhead, this.nodeMlNativeMemoryRequirementExcludingOverhead);
        return new NativeMemoryCapacity(tier, node, null);
    }

    public MlMemoryAutoscalingCapacity.Builder autoscalingCapacity(int maxMemoryPercent, boolean useAuto, long mlNativeMemoryForLargestMlNode, int numMlAvailabilityZones) {
        assert (this.nodeMlNativeMemoryRequirementExcludingOverhead >= 0L) : "Node required should not be negative - was: " + this.nodeMlNativeMemoryRequirementExcludingOverhead;
        assert (this.tierMlNativeMemoryRequirementExcludingOverhead >= this.nodeMlNativeMemoryRequirementExcludingOverhead) : "Total tier required should never be smaller than largest node size required: " + this.tierMlNativeMemoryRequirementExcludingOverhead + " < " + this.nodeMlNativeMemoryRequirementExcludingOverhead;
        if (this.tierMlNativeMemoryRequirementExcludingOverhead <= 0L || this.nodeMlNativeMemoryRequirementExcludingOverhead <= 0L) {
            if (this.tierMlNativeMemoryRequirementExcludingOverhead != 0L || this.nodeMlNativeMemoryRequirementExcludingOverhead != 0L) {
                logger.error("Request to calculate autoscaling capacity with tier requirement [{}] and node requirement [{}]", (Object)this.tierMlNativeMemoryRequirementExcludingOverhead, (Object)this.nodeMlNativeMemoryRequirementExcludingOverhead);
            }
            return MlMemoryAutoscalingCapacity.builder(ByteSizeValue.ZERO, ByteSizeValue.ZERO);
        }
        if (mlNativeMemoryForLargestMlNode <= MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes()) {
            logger.error("Largest possible ML node is too small to satisfy required ML native code overhead of [{}]", (Object)MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD);
            mlNativeMemoryForLargestMlNode = MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes() + 1L;
        } else if (mlNativeMemoryForLargestMlNode > 0x3FFFFFFFFFFFFFFFL) {
            mlNativeMemoryForLargestMlNode = 0x3FFFFFFFFFFFFFFFL;
        }
        long mlNativeMemoryForLargestMlNodeExcludingOverhead = mlNativeMemoryForLargestMlNode - MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
        long tierMlNativeMemoryRequirementPerZoneExcludingOverhead = numMlAvailabilityZones > 1 ? (this.tierMlNativeMemoryRequirementExcludingOverhead + (long)numMlAvailabilityZones - 1L) / (long)numMlAvailabilityZones : this.tierMlNativeMemoryRequirementExcludingOverhead;
        int numNodesPerZone = (int)((tierMlNativeMemoryRequirementPerZoneExcludingOverhead + mlNativeMemoryForLargestMlNodeExcludingOverhead - 1L) / mlNativeMemoryForLargestMlNodeExcludingOverhead);
        assert (numNodesPerZone > 0) : "calculated " + numNodesPerZone + " nodes per zone when tier memory requirement per zone was " + tierMlNativeMemoryRequirementPerZoneExcludingOverhead;
        long tierBasedMlNativeMemoryPerNodeExcludingOverhead = (tierMlNativeMemoryRequirementPerZoneExcludingOverhead + (long)numNodesPerZone - 1L) / (long)numNodesPerZone;
        long requiredNodeSize = NativeMemoryCalculator.calculateApproxNecessaryNodeSize(this.nodeMlNativeMemoryRequirementExcludingOverhead + MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), this.jvmSize, maxMemoryPercent, useAuto);
        long tierBasedRequiredNodeSize = NativeMemoryCalculator.calculateApproxNecessaryNodeSize(tierBasedMlNativeMemoryPerNodeExcludingOverhead + MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), this.jvmSize, maxMemoryPercent, useAuto);
        long requiredTierSize = tierBasedRequiredNodeSize * (long)numNodesPerZone * (long)Math.max(1, numMlAvailabilityZones);
        if (this.nodeMlNativeMemoryRequirementExcludingOverhead > mlNativeMemoryForLargestMlNodeExcludingOverhead) {
            logger.warn("Node memory requirement (excluding per-node overhead) [{}] exceeds ML memory (excluding per-node overhead) available on largest possible ML node [{}]", (Object)this.nodeMlNativeMemoryRequirementExcludingOverhead, (Object)mlNativeMemoryForLargestMlNodeExcludingOverhead);
        } else assert (requiredTierSize >= requiredNodeSize) : "Tier should always be AT LEAST the largest node size";
        return MlMemoryAutoscalingCapacity.builder(ByteSizeValue.ofBytes((long)requiredNodeSize), ByteSizeValue.ofBytes((long)Math.max(requiredTierSize, requiredNodeSize)));
    }

    public long getTierMlNativeMemoryRequirementExcludingOverhead() {
        return this.tierMlNativeMemoryRequirementExcludingOverhead;
    }

    public long getNodeMlNativeMemoryRequirementExcludingOverhead() {
        return this.nodeMlNativeMemoryRequirementExcludingOverhead;
    }

    public Long getJvmSize() {
        return this.jvmSize;
    }

    public String toString() {
        return "NativeMemoryCapacity{total ML native bytes=" + String.valueOf(ByteSizeValue.ofBytes((long)this.tierMlNativeMemoryRequirementExcludingOverhead)) + ", largest node ML native bytes=" + String.valueOf(ByteSizeValue.ofBytes((long)this.nodeMlNativeMemoryRequirementExcludingOverhead)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeMemoryCapacity that = (NativeMemoryCapacity)o;
        return this.tierMlNativeMemoryRequirementExcludingOverhead == that.tierMlNativeMemoryRequirementExcludingOverhead && this.nodeMlNativeMemoryRequirementExcludingOverhead == that.nodeMlNativeMemoryRequirementExcludingOverhead && Objects.equals(this.jvmSize, that.jvmSize);
    }

    public int hashCode() {
        return Objects.hash(this.tierMlNativeMemoryRequirementExcludingOverhead, this.nodeMlNativeMemoryRequirementExcludingOverhead, this.jvmSize);
    }

    public static NativeMemoryCapacity currentScale(List<DiscoveryNode> machineLearningNodes, int maxMachineMemoryPercent, boolean useAuto) {
        long[] mlMemory = machineLearningNodes.stream().mapToLong(node -> NativeMemoryCalculator.allowedBytesForMl(node, maxMachineMemoryPercent, useAuto).orElse(0L)).map(mem -> Math.max(mem - MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes(), 0L)).toArray();
        return new NativeMemoryCapacity(Arrays.stream(mlMemory).sum(), Arrays.stream(mlMemory).max().orElse(0L), machineLearningNodes.stream().map(NativeMemoryCapacity::getNodeJvmSize).filter(OptionalLong::isPresent).map(OptionalLong::getAsLong).max(Long::compare).orElse(null));
    }

    static OptionalLong getNodeJvmSize(DiscoveryNode node) {
        Map nodeAttributes = node.getAttributes();
        String valueStr = (String)nodeAttributes.get("ml.max_jvm_size");
        try {
            return OptionalLong.of(Long.parseLong(valueStr));
        }
        catch (NumberFormatException e) {
            assert (e == null) : "ml.max_jvm_size should parse because we set it internally: invalid value was " + valueStr;
            logger.debug("could not parse stored string value [{}] in node attribute [{}]", (Object)valueStr, (Object)"ml.max_jvm_size");
            return OptionalLong.empty();
        }
    }
}

