/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.changepoint;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ChangePointBucket
extends InternalMultiBucketAggregation.InternalBucketWritable
implements ToXContent {
    private final Object key;
    private final long docCount;
    private final InternalAggregations aggregations;

    public ChangePointBucket(Object key, long docCount, InternalAggregations aggregations) {
        this.key = key;
        this.docCount = docCount;
        this.aggregations = aggregations;
    }

    public ChangePointBucket(StreamInput in) throws IOException {
        this.key = in.readGenericValue();
        this.docCount = in.readVLong();
        this.aggregations = InternalAggregations.readFrom((StreamInput)in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
        builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
        this.aggregations.toXContentInternal(builder, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.key);
        out.writeVLong(this.docCount);
        this.aggregations.writeTo(out);
    }

    public Object getKey() {
        return this.key;
    }

    public String getKeyAsString() {
        return this.key.toString();
    }

    public long getDocCount() {
        return this.docCount;
    }

    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ChangePointBucket that = (ChangePointBucket)((Object)o);
        return this.docCount == that.docCount && Objects.equals(this.key, that.key) && Objects.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.docCount, this.aggregations);
    }
}

