/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public final class MlMetrics
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlMetrics.class);
    private final MeterRegistry meterRegistry;
    private final ClusterService clusterService;
    private final AutodetectProcessManager autodetectProcessManager;
    private final DataFrameAnalyticsManager dataFrameAnalyticsManager;
    private final boolean hasMasterRole;
    private final boolean hasMlRole;
    private final List<AutoCloseable> metrics = new ArrayList<AutoCloseable>();
    private static final Map<String, Object> MASTER_TRUE_MAP = Map.of("es.ml.is_master", Boolean.TRUE);
    private static final Map<String, Object> MASTER_FALSE_MAP = Map.of("es.ml.is_master", Boolean.FALSE);
    private volatile Map<String, Object> isMasterMap = MASTER_FALSE_MAP;
    private volatile boolean firstTime = true;
    private volatile MlTaskStatusCounts mlTaskStatusCounts = MlTaskStatusCounts.EMPTY;
    private volatile TrainedModelAllocationCounts trainedModelAllocationCounts = TrainedModelAllocationCounts.EMPTY;
    private volatile long nativeMemLimit;
    private volatile long nativeMemAdUsage;
    private volatile long nativeMemDfaUsage;
    private volatile long nativeMemTrainedModelUsage;
    private volatile long nativeMemFree;

    public MlMetrics(MeterRegistry meterRegistry, ClusterService clusterService, Settings settings, AutodetectProcessManager autodetectProcessManager, DataFrameAnalyticsManager dataFrameAnalyticsManager) {
        this.meterRegistry = meterRegistry;
        this.clusterService = clusterService;
        this.autodetectProcessManager = autodetectProcessManager;
        this.dataFrameAnalyticsManager = dataFrameAnalyticsManager;
        this.hasMasterRole = DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.MASTER_ROLE);
        this.hasMlRole = DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.ML_ROLE);
        if (this.hasMasterRole || this.hasMlRole) {
            clusterService.addListener((ClusterStateListener)this);
        }
    }

    private void registerMlNodeMetrics(MeterRegistry meterRegistry) {
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.native_memory.limit.size", "ML native memory limit on this node.", "bytes", () -> new LongWithAttributes(this.nativeMemLimit, Map.of())));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.native_memory.anomaly_detectors.usage", "ML native memory used by anomaly detection jobs on this node.", "bytes", () -> new LongWithAttributes(this.nativeMemAdUsage, Map.of())));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.native_memory.data_frame_analytics.usage", "ML native memory used by data frame analytics jobs on this node.", "bytes", () -> new LongWithAttributes(this.nativeMemDfaUsage, Map.of())));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.native_memory.trained_models.usage", "ML native memory used by trained models on this node.", "bytes", () -> new LongWithAttributes(this.nativeMemTrainedModelUsage, Map.of())));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.native_memory.free.size", "Free ML native memory on this node.", "bytes", () -> new LongWithAttributes(this.nativeMemFree, Map.of())));
    }

    private void registerMasterNodeMetrics(MeterRegistry meterRegistry) {
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.anomaly_detectors.opening.current", "Count of anomaly detection jobs in the opening state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.adOpeningCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.anomaly_detectors.opened.current", "Count of anomaly detection jobs in the opened state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.adOpenedCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.anomaly_detectors.closing.current", "Count of anomaly detection jobs in the closing state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.adClosingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.anomaly_detectors.failed.current", "Count of anomaly detection jobs in the failed state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.adFailedCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.datafeeds.starting.current", "Count of datafeeds in the starting state cluster-wide.", "datafeeds", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.datafeedStartingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.datafeeds.started.current", "Count of datafeeds in the started state cluster-wide.", "datafeeds", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.datafeedStartedCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.datafeeds.stopping.current", "Count of datafeeds in the stopping state cluster-wide.", "datafeeds", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.datafeedStoppingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.starting.current", "Count of data frame analytics jobs in the starting state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaStartingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.started.current", "Count of data frame analytics jobs in the started state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaStartedCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.reindexing.current", "Count of data frame analytics jobs in the reindexing state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaReindexingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.analyzing.current", "Count of data frame analytics jobs in the analyzing state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaAnalyzingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.stopping.current", "Count of data frame analytics jobs in the stopping state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaStoppingCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.data_frame_analytics.failed.current", "Count of data frame analytics jobs in the failed state cluster-wide.", "jobs", () -> new LongWithAttributes((long)this.mlTaskStatusCounts.dfaFailedCount, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.trained_models.deployment.target_allocations.current", "Sum of target trained model allocations across all deployments cluster-wide.", "allocations", () -> new LongWithAttributes((long)this.trainedModelAllocationCounts.trainedModelsTargetAllocations, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.trained_models.deployment.current_allocations.current", "Sum of current trained model allocations across all deployments cluster-wide.", "allocations", () -> new LongWithAttributes((long)this.trainedModelAllocationCounts.trainedModelsCurrentAllocations, this.isMasterMap)));
        this.metrics.add((AutoCloseable)meterRegistry.registerLongGauge("es.ml.trained_models.deployment.failed_allocations.current", "Sum of failed trained model allocations across all deployments cluster-wide.", "allocations", () -> new LongWithAttributes((long)this.trainedModelAllocationCounts.trainedModelsFailedAllocations, this.isMasterMap)));
    }

    protected void doStart() {
        this.metrics.clear();
        if (this.hasMasterRole) {
            this.registerMasterNodeMetrics(this.meterRegistry);
        }
        if (this.hasMlRole) {
            this.registerMlNodeMetrics(this.meterRegistry);
        }
    }

    protected void doStop() {
    }

    protected void doClose() {
        this.metrics.forEach(metric -> {
            try {
                metric.close();
            }
            catch (Exception e) {
                logger.warn("metrics close() method should not throw Exception", (Throwable)e);
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        TrainedModelAssignmentMetadata previousMetadata;
        Map<String, Object> map = this.isMasterMap = event.localNodeMaster() ? MASTER_TRUE_MAP : MASTER_FALSE_MAP;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean mustRecalculateFreeMem = false;
        ClusterState currentState = event.state();
        ClusterState previousState = event.previousState();
        if (this.firstTime || event.metadataChanged()) {
            PersistentTasksCustomMetadata oldTasks;
            PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
            PersistentTasksCustomMetadata persistentTasksCustomMetadata = oldTasks = this.firstTime ? null : (PersistentTasksCustomMetadata)previousState.getMetadata().custom("persistent_tasks");
            if (tasks != null && !tasks.equals((Object)oldTasks)) {
                if (this.hasMasterRole) {
                    this.mlTaskStatusCounts = MlMetrics.findTaskStatuses(tasks);
                }
                if (this.hasMlRole) {
                    this.nativeMemAdUsage = MlMetrics.findAdMemoryUsage(this.autodetectProcessManager);
                    this.nativeMemDfaUsage = MlMetrics.findDfaMemoryUsage(this.dataFrameAnalyticsManager, tasks);
                    mustRecalculateFreeMem = true;
                }
            }
        }
        TrainedModelAssignmentMetadata currentMetadata = TrainedModelAssignmentMetadata.fromState((ClusterState)currentState);
        TrainedModelAssignmentMetadata trainedModelAssignmentMetadata = previousMetadata = this.firstTime ? null : TrainedModelAssignmentMetadata.fromState((ClusterState)previousState);
        if (currentMetadata != null && !currentMetadata.equals((Object)previousMetadata)) {
            if (this.hasMasterRole) {
                this.trainedModelAllocationCounts = MlMetrics.findTrainedModelAllocationCounts(currentMetadata);
            }
            if (this.hasMlRole) {
                this.nativeMemTrainedModelUsage = MlMetrics.findTrainedModelMemoryUsage(currentMetadata, currentState.nodes().getLocalNode().getId());
                mustRecalculateFreeMem = true;
            }
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.nativeMemLimit = MlMetrics.findNativeMemoryLimit(currentState.nodes().getLocalNode(), this.clusterService.getClusterSettings());
            mustRecalculateFreeMem = true;
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearningField.USE_AUTO_MACHINE_MEMORY_PERCENT, s -> this.memoryLimitClusterSettingUpdated());
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, s -> this.memoryLimitClusterSettingUpdated());
        }
        if (mustRecalculateFreeMem) {
            this.nativeMemFree = MlMetrics.findNativeMemoryFree(this.nativeMemLimit, this.nativeMemAdUsage, this.nativeMemDfaUsage, this.nativeMemTrainedModelUsage);
        }
    }

    private void memoryLimitClusterSettingUpdated() {
        this.nativeMemLimit = MlMetrics.findNativeMemoryLimit(this.clusterService.localNode(), this.clusterService.getClusterSettings());
        this.nativeMemFree = MlMetrics.findNativeMemoryFree(this.nativeMemLimit, this.nativeMemAdUsage, this.nativeMemDfaUsage, this.nativeMemTrainedModelUsage);
    }

    static MlTaskStatusCounts findTaskStatuses(PersistentTasksCustomMetadata tasks) {
        int adOpeningCount = 0;
        int adOpenedCount = 0;
        int adClosingCount = 0;
        int adFailedCount = 0;
        int datafeedStartingCount = 0;
        int datafeedStartedCount = 0;
        int datafeedStoppingCount = 0;
        int dfaStartingCount = 0;
        int dfaStartedCount = 0;
        int dfaReindexingCount = 0;
        int dfaAnalyzingCount = 0;
        int dfaStoppingCount = 0;
        int dfaFailedCount = 0;
        for (PersistentTasksCustomMetadata.PersistentTask task : tasks.tasks()) {
            block6 : switch (task.getTaskName()) {
                case "xpack/ml/job": {
                    switch (MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetadata.PersistentTask)task)) {
                        case OPENING: {
                            ++adOpeningCount;
                            break block6;
                        }
                        case OPENED: {
                            ++adOpenedCount;
                            break block6;
                        }
                        case CLOSING: {
                            ++adClosingCount;
                            break block6;
                        }
                        case FAILED: {
                            ++adFailedCount;
                        }
                    }
                    break;
                }
                case "xpack/ml/datafeed": {
                    switch (MlTasks.getDatafeedState((PersistentTasksCustomMetadata.PersistentTask)task)) {
                        case STARTING: {
                            ++datafeedStartingCount;
                            break block6;
                        }
                        case STARTED: {
                            ++datafeedStartedCount;
                            break block6;
                        }
                        case STOPPING: {
                            ++datafeedStoppingCount;
                        }
                    }
                    break;
                }
                case "xpack/ml/data_frame/analytics": {
                    switch (MlTasks.getDataFrameAnalyticsState((PersistentTasksCustomMetadata.PersistentTask)task)) {
                        case STARTING: {
                            ++dfaStartingCount;
                            break block6;
                        }
                        case STARTED: {
                            ++dfaStartedCount;
                            break block6;
                        }
                        case REINDEXING: {
                            ++dfaReindexingCount;
                            break block6;
                        }
                        case ANALYZING: {
                            ++dfaAnalyzingCount;
                            break block6;
                        }
                        case STOPPING: {
                            ++dfaStoppingCount;
                            break block6;
                        }
                        case FAILED: {
                            ++dfaFailedCount;
                        }
                    }
                    break;
                }
            }
        }
        return new MlTaskStatusCounts(adOpeningCount, adOpenedCount, adClosingCount, adFailedCount, datafeedStartingCount, datafeedStartedCount, datafeedStoppingCount, dfaStartingCount, dfaStartedCount, dfaReindexingCount, dfaAnalyzingCount, dfaStoppingCount, dfaFailedCount);
    }

    static long findAdMemoryUsage(AutodetectProcessManager autodetectProcessManager) {
        return autodetectProcessManager.getOpenProcessMemoryUsage().getBytes();
    }

    static long findDfaMemoryUsage(DataFrameAnalyticsManager dataFrameAnalyticsManager, PersistentTasksCustomMetadata tasks) {
        return dataFrameAnalyticsManager.getActiveTaskMemoryUsage(tasks).getBytes();
    }

    static TrainedModelAllocationCounts findTrainedModelAllocationCounts(TrainedModelAssignmentMetadata metadata) {
        int trainedModelsTargetAllocations = 0;
        int trainedModelsCurrentAllocations = 0;
        int trainedModelsFailedAllocations = 0;
        for (TrainedModelAssignment trainedModelAssignment : metadata.allAssignments().values()) {
            trainedModelsTargetAllocations += trainedModelAssignment.totalTargetAllocations();
            trainedModelsCurrentAllocations += trainedModelAssignment.totalCurrentAllocations();
            trainedModelsFailedAllocations += trainedModelAssignment.totalFailedAllocations();
        }
        return new TrainedModelAllocationCounts(trainedModelsTargetAllocations, trainedModelsCurrentAllocations, trainedModelsFailedAllocations);
    }

    static long findTrainedModelMemoryUsage(TrainedModelAssignmentMetadata metadata, String localNodeId) {
        long trainedModelMemoryUsageBytes = 0L;
        for (TrainedModelAssignment assignment : metadata.allAssignments().values()) {
            if (!Optional.ofNullable((RoutingInfo)assignment.getNodeRoutingTable().get(localNodeId)).map(RoutingInfo::getState).orElse(RoutingState.STOPPED).consumesMemory()) continue;
            trainedModelMemoryUsageBytes += assignment.getTaskParams().estimateMemoryUsageBytes();
        }
        return trainedModelMemoryUsageBytes;
    }

    static long findNativeMemoryLimit(DiscoveryNode localNode, ClusterSettings settings) {
        return NativeMemoryCalculator.allowedBytesForMl(localNode, settings).orElse(0L);
    }

    static long findNativeMemoryFree(long nativeMemLimit, long nativeMemAdUsage, long nativeMemDfaUsage, long nativeMemTrainedModelUsage) {
        long totalUsage = nativeMemAdUsage + nativeMemDfaUsage + nativeMemTrainedModelUsage;
        if (totalUsage > 0L) {
            totalUsage += MachineLearning.NATIVE_EXECUTABLE_CODE_OVERHEAD.getBytes();
        }
        return nativeMemLimit - totalUsage;
    }

    record MlTaskStatusCounts(int adOpeningCount, int adOpenedCount, int adClosingCount, int adFailedCount, int datafeedStartingCount, int datafeedStartedCount, int datafeedStoppingCount, int dfaStartingCount, int dfaStartedCount, int dfaReindexingCount, int dfaAnalyzingCount, int dfaStoppingCount, int dfaFailedCount) {
        static final MlTaskStatusCounts EMPTY = new MlTaskStatusCounts(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    record TrainedModelAllocationCounts(int trainedModelsTargetAllocations, int trainedModelsCurrentAllocations, int trainedModelsFailedAllocations) {
        static final TrainedModelAllocationCounts EMPTY = new TrainedModelAllocationCounts(0, 0, 0);
    }
}

