/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import java.util.stream.IntStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

public class BooleanBucketedSort
implements Releasable {
    private final BigArrays bigArrays;
    private final SortOrder order;
    private final int bucketSize;
    private IntArray values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanBucketedSort(BigArrays bigArrays, SortOrder order, int bucketSize) {
        this.bigArrays = bigArrays;
        this.order = order;
        this.bucketSize = bucketSize;
        boolean success = false;
        try {
            this.values = bigArrays.newIntArray(0L, true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void collect(boolean value, int bucket) {
        long rootIndex = (long)bucket * 2L;
        long requiredSize = rootIndex + 2L;
        if (this.values.size() < requiredSize) {
            this.grow(requiredSize);
        }
        if (value) {
            this.values.increment(rootIndex + 1L, 1);
        } else {
            this.values.increment(rootIndex, 1);
        }
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void merge(int groupId, BooleanBucketedSort other, int otherGroupId) {
        int trueValues;
        long otherRootIndex = (long)otherGroupId * 2L;
        if (other.values.size() < otherRootIndex + 2L) {
            return;
        }
        int falseValues = other.values.get(otherRootIndex);
        if (falseValues + (trueValues = other.values.get(otherRootIndex + 1L)) == 0) {
            return;
        }
        long rootIndex = (long)groupId * 2L;
        long requiredSize = rootIndex + 2L;
        if (this.values.size() < requiredSize) {
            this.grow(requiredSize);
        }
        this.values.increment(rootIndex, falseValues);
        this.values.increment(rootIndex + 1L, trueValues);
    }

    public Block toBlock(BlockFactory blockFactory, IntVector selected) {
        block20: {
            block19: {
                if (this.bucketSize == 0) break block19;
                if (!IntStream.range(0, selected.getPositionCount()).map(selected::getInt).noneMatch(bucket -> {
                    long rootIndex = (long)bucket * 2L;
                    if (this.values.size() < rootIndex + 2L) {
                        return false;
                    }
                    int size = this.values.get(rootIndex) + this.values.get(rootIndex + 1L);
                    return size > 0;
                })) break block20;
            }
            return blockFactory.newConstantNullBlock(selected.getPositionCount());
        }
        try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(selected.getPositionCount());){
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                int trueValues;
                int bucket2 = selected.getInt(s);
                long rootIndex = (long)bucket2 * 2L;
                if (this.values.size() < rootIndex + 2L) {
                    builder.appendNull();
                    continue;
                }
                int falseValues = this.values.get(rootIndex);
                long totalValues = (long)falseValues + (long)(trueValues = this.values.get(rootIndex + 1L));
                if (totalValues == 0L) {
                    builder.appendNull();
                    continue;
                }
                if (totalValues == 1L) {
                    builder.appendBoolean(trueValues > 0);
                    continue;
                }
                builder.beginPositionEntry();
                if (this.order == SortOrder.ASC) {
                    int falseValuesToAdd = Math.min(falseValues, this.bucketSize);
                    int trueValuesToAdd = Math.min(trueValues, this.bucketSize - falseValuesToAdd);
                    for (i = 0; i < falseValuesToAdd; ++i) {
                        builder.appendBoolean(false);
                    }
                    for (i = 0; i < trueValuesToAdd; ++i) {
                        builder.appendBoolean(true);
                    }
                } else {
                    int trueValuesToAdd = Math.min(trueValues, this.bucketSize);
                    int falseValuesToAdd = Math.min(falseValues, this.bucketSize - trueValuesToAdd);
                    for (i = 0; i < trueValuesToAdd; ++i) {
                        builder.appendBoolean(true);
                    }
                    for (i = 0; i < falseValuesToAdd; ++i) {
                        builder.appendBoolean(false);
                    }
                }
                builder.endPositionEntry();
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    private void grow(long minSize) {
        this.values = this.bigArrays.grow(this.values, minSize);
    }

    public final void close() {
        Releasables.close((Releasable)this.values);
    }
}

