/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.AbstractVectorBuilder;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefArrayVector;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ConstantBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class BytesRefVectorBuilder
extends AbstractVectorBuilder
implements BytesRefVector.Builder {
    private BytesRefArray values;

    BytesRefVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        this(estimatedSize, BigArrays.NON_RECYCLING_INSTANCE, blockFactory);
    }

    BytesRefVectorBuilder(int estimatedSize, BigArrays bigArrays, BlockFactory blockFactory) {
        super(blockFactory);
        this.values = new BytesRefArray((long)Math.max(estimatedSize, 2), bigArrays);
    }

    @Override
    public BytesRefVectorBuilder appendBytesRef(BytesRef value) {
        this.ensureCapacity();
        this.values.append(value);
        ++this.valueCount;
        return this;
    }

    @Override
    protected int elementSize() {
        return -1;
    }

    @Override
    protected int valuesLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void growValuesArray(int newSize) {
        throw new AssertionError((Object)"should not reach here");
    }

    @Override
    public BytesRefVector build() {
        AbstractVector vector;
        this.finish();
        assert (this.estimatedBytes == 0L);
        if (this.valueCount == 1) {
            vector = new ConstantBytesRefVector(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, new BytesRef())), 1, this.blockFactory);
            this.blockFactory.adjustBreaker(vector.ramBytesUsed());
            Releasables.closeExpectNoException((Releasable)this.values);
        } else {
            vector = new BytesRefArrayVector(this.values, this.valueCount, this.blockFactory);
            this.blockFactory.adjustBreaker(vector.ramBytesUsed() - this.values.bigArraysRamBytesUsed());
        }
        this.values = null;
        this.built();
        return vector;
    }

    @Override
    public void extraClose() {
        Releasables.closeExpectNoException((Releasable)this.values);
    }
}

