/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.BitSet;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupeLong;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class LongBlockHash
extends BlockHash {
    private final int channel;
    final LongHash hash;
    private boolean seenNull;

    LongBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
        this.hash = new LongHash(1L, blockFactory.bigArrays());
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
            return;
        }
        LongBlock castBlock = (LongBlock)block;
        LongVector vector = castBlock.asVector();
        if (vector == null) {
            try (IntBlock groupIds = this.add(castBlock);){
                addInput.add(0, groupIds);
            }
            return;
        }
        try (IntVector groupIds = this.add(vector);){
            addInput.add(0, groupIds);
        }
    }

    IntVector add(LongVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                long v = vector.getLong(i);
                builder.appendInt(Math.toIntExact(LongBlockHash.hashOrdToGroupNullReserved(this.hash.add(v))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    IntBlock add(LongBlock block) {
        MultivalueDedupe.HashResult result = new MultivalueDedupeLong(block).hashAdd(this.blockFactory, this.hash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            return ReleasableIterator.single((Releasable)this.blockFactory.newConstantIntVector(0, block.getPositionCount()).asBlock());
        }
        LongBlock castBlock = (LongBlock)block;
        LongVector vector = castBlock.asVector();
        if (vector == null) {
            return ReleasableIterator.single((Releasable)this.lookup(castBlock));
        }
        return ReleasableIterator.single((Releasable)this.lookup(vector));
    }

    private IntBlock lookup(LongVector vector) {
        int positions = vector.getPositionCount();
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                long v = vector.getLong(i);
                long found = this.hash.find(v);
                if (found < 0L) {
                    builder.appendNull();
                    continue;
                }
                builder.appendInt(Math.toIntExact(LongBlockHash.hashOrdToGroupNullReserved(found)));
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private IntBlock lookup(LongBlock block) {
        return new MultivalueDedupeLong(block).hashLookup(this.blockFactory, this.hash);
    }

    public LongBlock[] getKeys() {
        if (this.seenNull) {
            int size = Math.toIntExact(this.hash.size() + 1L);
            long[] keys = new long[size];
            for (int i = 1; i < size; ++i) {
                keys[i] = this.hash.get((long)(i - 1));
            }
            BitSet nulls = new BitSet(1);
            nulls.set(0);
            return new LongBlock[]{this.blockFactory.newLongArrayBlock(keys, keys.length, null, nulls, Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING)};
        }
        int size = Math.toIntExact(this.hash.size());
        long[] keys = new long[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.hash.get((long)i);
        }
        return new LongBlock[]{this.blockFactory.newLongArrayVector(keys, keys.length).asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.hash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.hash.close();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongBlockHash{channel=").append(this.channel);
        b.append(", entries=").append(this.hash.size());
        b.append(", seenNull=").append(this.seenNull);
        return b.append('}').toString();
    }
}

