/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.DOUBLE));
    private final DriverContext driverContext;
    private final TopDoubleAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopDoubleAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopDoubleAggregatorFunction(driverContext, channels, TopDoubleAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
            DoubleVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        DoubleBlock block = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(DoubleVector vector) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            TopDoubleAggregator.combine(this.state, vector.getDouble(i));
        }
    }

    private void addRawVector(DoubleVector vector, BooleanVector mask) {
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            TopDoubleAggregator.combine(this.state, vector.getDouble(i));
        }
    }

    private void addRawBlock(DoubleBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                TopDoubleAggregator.combine(this.state, block.getDouble(i));
            }
        }
    }

    private void addRawBlock(DoubleBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                TopDoubleAggregator.combine(this.state, block.getDouble(i));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopDoubleAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock top = (DoubleBlock)topUncast;
        assert (top.getPositionCount() == 1);
        TopDoubleAggregator.combineIntermediate(this.state, top);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopDoubleAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

