/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

final class LongFallibleState
implements AggregatorState {
    private long value;
    private boolean seen;
    private boolean failed;

    LongFallibleState(long init) {
        this.value = init;
    }

    long longValue() {
        return this.value;
    }

    void longValue(long value) {
        this.value = value;
    }

    boolean seen() {
        return this.seen;
    }

    void seen(boolean seen) {
        this.seen = seen;
    }

    boolean failed() {
        return this.failed;
    }

    void failed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        blocks[offset + 0] = driverContext.blockFactory().newConstantLongBlockWith(this.value, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantBooleanBlockWith(this.seen, 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantBooleanBlockWith(this.failed, 1);
    }

    public void close() {
    }
}

