/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.util.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.enrich.EnrichPlugin;
import org.elasticsearch.xpack.enrich.action.EnrichShardMultiSearchAction;

public class EnrichCoordinatorProxyAction
extends ActionType<SearchResponse> {
    public static final EnrichCoordinatorProxyAction INSTANCE = new EnrichCoordinatorProxyAction();
    public static final String NAME = "indices:data/read/xpack/enrich/coordinate_lookups";

    private EnrichCoordinatorProxyAction() {
        super(NAME);
    }

    public static class Coordinator {
        final BiConsumer<MultiSearchRequest, BiConsumer<MultiSearchResponse, Exception>> lookupFunction;
        final int maxLookupsPerRequest;
        final int maxNumberOfConcurrentRequests;
        final int queueCapacity;
        final BlockingQueue<Slot> queue;
        final Semaphore remoteRequestPermits;
        final LongAdder remoteRequestsTotal = new LongAdder();
        final LongAdder executedSearchesTotal = new LongAdder();

        public Coordinator(Client client, Settings settings) {
            this(Coordinator.lookupFunction((ElasticsearchClient)client), (Integer)EnrichPlugin.COORDINATOR_PROXY_MAX_LOOKUPS_PER_REQUEST.get(settings), (Integer)EnrichPlugin.COORDINATOR_PROXY_MAX_CONCURRENT_REQUESTS.get(settings), (Integer)EnrichPlugin.COORDINATOR_PROXY_QUEUE_CAPACITY.get(settings));
        }

        Coordinator(BiConsumer<MultiSearchRequest, BiConsumer<MultiSearchResponse, Exception>> lookupFunction, int maxLookupsPerRequest, int maxNumberOfConcurrentRequests, int queueCapacity) {
            this.lookupFunction = lookupFunction;
            this.maxLookupsPerRequest = maxLookupsPerRequest;
            this.maxNumberOfConcurrentRequests = maxNumberOfConcurrentRequests;
            this.queueCapacity = queueCapacity;
            this.queue = new ArrayBlockingQueue<Slot>(queueCapacity);
            this.remoteRequestPermits = new Semaphore(maxNumberOfConcurrentRequests);
        }

        void schedule(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
            boolean accepted = this.queue.offer(new Slot(searchRequest, listener));
            int queueSize = this.queue.size();
            this.coordinateLookups();
            if (!accepted) {
                listener.onFailure((Exception)((Object)new EsRejectedExecutionException("Could not perform enrichment, enrich coordination queue at capacity [" + queueSize + "/" + this.queueCapacity + "]")));
            }
        }

        EnrichStatsAction.Response.CoordinatorStats getStats(String nodeId) {
            return new EnrichStatsAction.Response.CoordinatorStats(nodeId, this.queue.size(), this.getRemoteRequestsCurrent(), this.remoteRequestsTotal.longValue(), this.executedSearchesTotal.longValue());
        }

        int getRemoteRequestsCurrent() {
            return this.maxNumberOfConcurrentRequests - this.remoteRequestPermits.availablePermits();
        }

        void coordinateLookups() {
            while (this.remoteRequestPermits.tryAcquire()) {
                ArrayList slots = new ArrayList(Math.min(this.queue.size(), this.maxLookupsPerRequest));
                if (this.queue.drainTo(slots, this.maxLookupsPerRequest) == 0) {
                    this.remoteRequestPermits.release();
                    if (!this.queue.isEmpty()) continue;
                    return;
                }
                assert (!slots.isEmpty());
                this.remoteRequestsTotal.increment();
                MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
                slots.forEach(slot -> multiSearchRequest.add(slot.request));
                this.lookupFunction.accept((Object)multiSearchRequest, (response, e) -> this.handleResponse(slots, (MultiSearchResponse)response, (Exception)e));
            }
            return;
        }

        void handleResponse(List<Slot> slots, MultiSearchResponse response, Exception e) {
            this.remoteRequestPermits.release();
            this.executedSearchesTotal.add(slots.size());
            if (response != null) {
                assert (slots.size() == response.getResponses().length);
                for (int i = 0; i < response.getResponses().length; ++i) {
                    MultiSearchResponse.Item responseItem = response.getResponses()[i];
                    Slot slot2 = slots.get(i);
                    if (responseItem.isFailure()) {
                        slot2.listener.onFailure(responseItem.getFailure());
                        continue;
                    }
                    slot2.listener.onResponse((Object)responseItem.getResponse());
                }
            } else if (e != null) {
                slots.forEach(slot -> slot.listener.onFailure(e));
            } else {
                throw new AssertionError((Object)"no response and no error");
            }
            this.coordinateLookups();
        }

        static BiConsumer<MultiSearchRequest, BiConsumer<MultiSearchResponse, Exception>> lookupFunction(ElasticsearchClient client) {
            return (request, consumer) -> {
                int slot = 0;
                HashMap<String, List> itemsPerIndex = new HashMap<String, List>();
                for (SearchRequest searchRequest : request.requests()) {
                    List items = itemsPerIndex.computeIfAbsent(searchRequest.indices()[0], k -> new ArrayList());
                    items.add(new Tuple((Object)slot, (Object)searchRequest));
                    ++slot;
                }
                AtomicInteger counter = new AtomicInteger(0);
                ConcurrentHashMap shardResponses = new ConcurrentHashMap();
                for (Map.Entry entry : itemsPerIndex.entrySet()) {
                    String enrichIndexName = (String)entry.getKey();
                    List enrichIndexRequestsAndSlots = (List)entry.getValue();
                    ActionListener listener = ActionListener.wrap(response -> {
                        shardResponses.put(enrichIndexName, new Tuple(response, null));
                        response.incRef();
                        if (counter.incrementAndGet() == itemsPerIndex.size()) {
                            MultiSearchResponse res = Coordinator.reduce(request.requests().size(), itemsPerIndex, shardResponses);
                            try {
                                consumer.accept((Object)res, null);
                            }
                            finally {
                                res.decRef();
                            }
                        }
                    }, e -> {
                        shardResponses.put(enrichIndexName, new Tuple(null, e));
                        if (counter.incrementAndGet() == itemsPerIndex.size()) {
                            MultiSearchResponse res = Coordinator.reduce(request.requests().size(), itemsPerIndex, shardResponses);
                            try {
                                consumer.accept((Object)res, null);
                            }
                            finally {
                                res.decRef();
                            }
                        }
                    });
                    MultiSearchRequest mrequest = new MultiSearchRequest();
                    enrichIndexRequestsAndSlots.stream().map(Tuple::v2).forEach(arg_0 -> ((MultiSearchRequest)mrequest).add(arg_0));
                    client.execute((ActionType)EnrichShardMultiSearchAction.INSTANCE, (ActionRequest)new EnrichShardMultiSearchAction.Request(mrequest), listener);
                }
            };
        }

        static MultiSearchResponse reduce(int numRequest, Map<String, List<Tuple<Integer, SearchRequest>>> itemsPerIndex, Map<String, Tuple<MultiSearchResponse, Exception>> shardResponses) {
            MultiSearchResponse.Item[] items = new MultiSearchResponse.Item[numRequest];
            Iterator<Map.Entry<String, Tuple<MultiSearchResponse, Exception>>> iterator = shardResponses.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Tuple<MultiSearchResponse, Exception>> rspEntry = iterator.next();
                List<Tuple<Integer, SearchRequest>> reqSlots = itemsPerIndex.get(rspEntry.getKey());
                if (rspEntry.getValue().v1() != null) {
                    MultiSearchResponse shardResponse = (MultiSearchResponse)rspEntry.getValue().v1();
                    for (int i = 0; i < shardResponse.getResponses().length; ++i) {
                        MultiSearchResponse.Item res;
                        int slot = (Integer)reqSlots.get(i).v1();
                        items[slot] = res = shardResponse.getResponses()[i];
                        SearchResponse r = res.getResponse();
                        if (r == null) continue;
                        r.incRef();
                    }
                    iterator.remove();
                    shardResponse.decRef();
                    continue;
                }
                if (rspEntry.getValue().v2() != null) {
                    Exception e = (Exception)rspEntry.getValue().v2();
                    for (Tuple<Integer, SearchRequest> originSlot : reqSlots) {
                        items[((Integer)originSlot.v1()).intValue()] = new MultiSearchResponse.Item(null, e);
                    }
                    continue;
                }
                throw new AssertionError();
            }
            return new MultiSearchResponse(items, 1L);
        }

        record Slot(SearchRequest request, ActionListener<SearchResponse> listener) {
            Slot {
                Objects.requireNonNull(request);
                Objects.requireNonNull(listener);
            }
        }
    }

    public static class TransportAction
    extends HandledTransportAction<SearchRequest, SearchResponse> {
        private final Coordinator coordinator;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, Coordinator coordinator) {
            super(EnrichCoordinatorProxyAction.NAME, transportService, actionFilters, SearchRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.coordinator = coordinator;
        }

        protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> listener) {
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"write", "system_write", "search", "management"}));
            this.coordinator.schedule(request, listener);
        }
    }
}

