/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.InPipe;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class In
extends ScalarFunction {
    private final Expression value;
    private final List<Expression> list;
    private final ZoneId zoneId;

    public In(Source source, Expression value, List<Expression> list) {
        this(source, value, list, null);
    }

    public In(Source source, Expression value, List<Expression> list, ZoneId zoneId) {
        super(source, CollectionUtils.combine(list, value));
        this.value = value;
        this.list = new ArrayList<Expression>(new LinkedHashSet<Expression>(list));
        this.zoneId = zoneId;
    }

    @Override
    protected NodeInfo<In> info() {
        return NodeInfo.create(this, In::new, this.value(), this.list(), this.zoneId());
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new In(this.source(), newChildren.get(newChildren.size() - 1), newChildren.subList(0, newChildren.size() - 1), this.zoneId());
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public Expression value() {
        return this.value;
    }

    public List<Expression> list() {
        return this.list;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children()) || Expressions.foldable(this.list) && this.list().stream().allMatch(Expressions::isNull);
    }

    @Override
    public Boolean fold() {
        if (Expressions.isNull(this.value) || this.list.size() == 1 && Expressions.isNull(this.list.get(0))) {
            return null;
        }
        return InProcessor.apply(this.value.fold(), this.foldAndConvertListOfValues(this.list, this.value.dataType()));
    }

    @Override
    protected Expression canonicalize() {
        List<Expression> canonicalValues = Expressions.canonicalize(this.list);
        Collections.sort(canonicalValues, (l, r) -> Integer.compare(l.hashCode(), r.hashCode()));
        return new In(this.source(), this.value, canonicalValues, this.zoneId);
    }

    @Override
    public ScriptTemplate asScript() {
        ScriptTemplate leftScript = this.asScript(this.value);
        ArrayList<Object> values = new ArrayList<Object>(new LinkedHashSet<Object>(this.foldAndConvertListOfValues(this.list, this.value.dataType())));
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{ql}.", (String)"in({}, {})", (Object[])new Object[]{leftScript.template()})), ParamsBuilder.paramsBuilder().script(leftScript.params()).variable(values).build(), this.dataType());
    }

    protected List<Object> foldAndConvertListOfValues(List<Expression> expressions, DataType dataType) {
        ArrayList<Object> values = new ArrayList<Object>(expressions.size());
        for (Expression e : expressions) {
            values.add(DataTypeConverter.convert(Foldables.valueOf(e), dataType));
        }
        return values;
    }

    protected boolean areCompatible(DataType left, DataType right) {
        return DataTypes.areCompatible(left, right);
    }

    @Override
    protected Pipe makePipe() {
        return new InPipe(this.source(), this, this.children().stream().map(Expressions::pipe).collect(Collectors.toList()));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isExact(this.value, this.functionName(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        for (Expression ex : this.list) {
            if (ex.foldable()) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Comparisons against fields are not (currently) supported; offender [{}] in [{}]", (Object[])new Object[]{Expressions.name(ex), this.sourceText()}));
        }
        DataType dt = this.value.dataType();
        for (int i = 0; i < this.list.size(); ++i) {
            Expression listValue = this.list.get(i);
            if (this.areCompatible(dt, listValue.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal(i + 1), this.sourceText(), dt.typeName(), Expressions.name(listValue), listValue.dataType().typeName()}));
        }
        return super.resolveType();
    }

    public Expression.TypeResolution validateInTypes() {
        return this.resolveType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.list);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        In other = (In)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.list, other.list);
    }
}

