/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.querydsl.container;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;
import org.elasticsearch.xpack.eql.expression.OptionalMissingAttribute;
import org.elasticsearch.xpack.eql.querydsl.container.CompositeAggRef;
import org.elasticsearch.xpack.eql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.eql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.ConstantInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;

public class FieldExtractorRegistry {
    private final Map<String, FieldExtraction> cache = new HashMap<String, FieldExtraction>();

    public FieldExtraction fieldExtraction(Expression expression) {
        return this.cache.computeIfAbsent(Expressions.id((Expression)expression), k -> FieldExtractorRegistry.createFieldExtractionFor(expression));
    }

    public FieldExtraction compositeKeyExtraction(Expression expression) {
        return this.cache.computeIfAbsent(Expressions.id((Expression)expression), k -> FieldExtractorRegistry.createKeyExtractionFor(expression));
    }

    private static FieldExtraction createKeyExtractionFor(Expression expression) {
        if (expression instanceof FieldAttribute) {
            FieldAttribute fieldAttribute = (FieldAttribute)expression;
            FieldAttribute fa = fieldAttribute.exactAttribute();
            if (fa.isNested()) {
                throw new UnsupportedOperationException("Nested not yet supported");
            }
            return new CompositeAggRef(fa.name());
        }
        if (expression instanceof OptionalMissingAttribute) {
            return new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, null));
        }
        throw new EqlIllegalArgumentException("Unsupported expression [{}]", expression);
    }

    private static FieldExtraction createFieldExtractionFor(Expression expression) {
        if (expression instanceof FieldAttribute) {
            FieldAttribute fieldAttribute = (FieldAttribute)expression;
            FieldAttribute fa = fieldAttribute.exactAttribute();
            if (fa.isNested()) {
                throw new UnsupportedOperationException("Nested not yet supported");
            }
            return FieldExtractorRegistry.topHitFieldExtractor(fa);
        }
        if (expression instanceof OptionalMissingAttribute) {
            return new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, null));
        }
        if (expression.foldable()) {
            return new ComputedRef((Pipe)new ConstantInput(expression.source(), expression, expression.fold()));
        }
        throw new EqlIllegalArgumentException("Unsupported expression [{}]", expression);
    }

    private static FieldExtraction topHitFieldExtractor(FieldAttribute fieldAttr) {
        return new SearchHitFieldRef(fieldAttr.name(), fieldAttr.field().getDataType(), fieldAttr.field().isAlias());
    }
}

