/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.batch.BlobBatchHelper;
import com.azure.storage.blob.models.BlobStorageException;
import java.util.HashSet;
import java.util.Set;

final class BlobBatchOperationResponse<T>
implements Response<T> {
    private static final ClientLogger LOGGER = new ClientLogger(BlobBatchOperationResponse.class);
    private final Set<Integer> expectedStatusCodes = new HashSet<Integer>();
    private int statusCode;
    private HttpHeaders headers;
    private HttpRequest request;
    private T value;
    private BlobStorageException exception;
    private boolean responseReceived = false;

    BlobBatchOperationResponse(int ... expectedStatusCodes) {
        for (int expectedStatusCode : expectedStatusCodes) {
            this.expectedStatusCodes.add(expectedStatusCode);
        }
    }

    public int getStatusCode() {
        this.assertResponseReceived();
        return this.statusCode;
    }

    BlobBatchOperationResponse<T> setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HttpHeaders getHeaders() {
        this.assertResponseReceived();
        return this.headers;
    }

    BlobBatchOperationResponse<T> setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest getRequest() {
        this.assertResponseReceived();
        return this.request;
    }

    BlobBatchOperationResponse<T> setRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public T getValue() {
        this.assertResponseReceived();
        return this.value;
    }

    BlobBatchOperationResponse<T> setValue(T value) {
        this.value = value;
        return this;
    }

    BlobBatchOperationResponse<T> setResponseReceived() {
        this.responseReceived = true;
        return this;
    }

    BlobBatchOperationResponse<T> setException(BlobStorageException exception) {
        this.exception = exception;
        return this;
    }

    boolean wasExpectedResponse() {
        return this.expectedStatusCodes.contains(this.statusCode);
    }

    HttpResponse asHttpResponse(String body) {
        return BlobBatchHelper.createHttpResponse(this.request, this.statusCode, this.headers, body);
    }

    private void assertResponseReceived() {
        if (!this.responseReceived) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new UnsupportedOperationException("Batch request has not been sent."));
        }
        if (!this.expectedStatusCodes.contains(this.statusCode)) {
            throw this.exception;
        }
    }
}

