/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.rules.action.PutQueryRuleAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutQueryRuleAction
extends EnterpriseSearchBaseRestHandler {
    public RestPutQueryRuleAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.QUERY_RULES);
    }

    public String getName() {
        return "query_rule_put_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_query_rules/{ruleset_id}/_rule/{rule_id}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutQueryRuleAction.Request request = new PutQueryRuleAction.Request(restRequest.param("ruleset_id"), restRequest.param("rule_id"), (BytesReference)restRequest.requiredContent(), restRequest.getXContentType());
        return channel -> client.execute(PutQueryRuleAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, PutQueryRuleAction.Response::status, r -> null));
    }
}

