/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

@Deprecated
public class PutAnalyticsCollectionAction {
    public static final String NAME = "cluster:admin/xpack/application/analytics/put";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/application/analytics/put");

    private PutAnalyticsCollectionAction() {
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        public static final ParseField COLLECTION_NAME_FIELD = new ParseField("name", new String[0]);
        private final String name;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public Response(boolean acknowledged, String name) {
            super(acknowledged);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public int hashCode() {
            return 31 * super.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.isAcknowledged() == response.isAcknowledged() && Objects.equals(this.name, response.name);
        }

        protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(COLLECTION_NAME_FIELD.getPreferredName(), this.name);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private final String name;
        public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public Request(TimeValue masterNodeTimeout, String name) {
            super(masterNodeTimeout);
            this.name = name;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || this.name.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"Analytics collection name is missing", validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.endObject();
            return builder;
        }
    }
}

