/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalBounds;
import org.elasticsearch.xpack.spatial.common.CartesianBoundingBox;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianBounds;

public class InternalCartesianBounds
extends InternalBounds<CartesianPoint>
implements CartesianBounds {
    public final double left;
    public final double right;

    public InternalCartesianBounds(String name, double top, double bottom, double left, double right, Map<String, Object> metadata) {
        super(name, top, bottom, metadata);
        this.left = left;
        this.right = right;
    }

    public InternalCartesianBounds(StreamInput in) throws IOException {
        super(in);
        this.left = in.readDouble();
        this.right = in.readDouble();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.left);
        out.writeDouble(this.right);
    }

    static InternalCartesianBounds empty(String name, Map<String, Object> metadata) {
        return new InternalCartesianBounds(name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, metadata);
    }

    public String getWriteableName() {
        return "cartesian_bounds";
    }

    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;

            public void accept(InternalAggregation aggregation) {
                InternalCartesianBounds bounds = (InternalCartesianBounds)aggregation;
                this.top = Math.max(this.top, bounds.top);
                this.bottom = Math.min(this.bottom, bounds.bottom);
                this.left = Math.min(this.left, bounds.left);
                this.right = Math.max(this.right, bounds.right);
            }

            public InternalAggregation get() {
                return new InternalCartesianBounds(InternalCartesianBounds.this.name, this.top, this.bottom, this.left, this.right, InternalCartesianBounds.this.getMetadata());
            }
        };
    }

    protected Object selectCoordinate(String coordinateString, CartesianPoint cornerPoint) {
        return switch (coordinateString) {
            case "x" -> cornerPoint.getX();
            case "y" -> cornerPoint.getY();
            default -> throw new IllegalArgumentException("Found unknown path element [" + coordinateString + "] in [" + this.getName() + "]");
        };
    }

    protected BoundingBox<CartesianPoint> resolveBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        return new CartesianBoundingBox(new CartesianPoint(this.left, this.top), new CartesianPoint(this.right, this.bottom));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCartesianBounds other = (InternalCartesianBounds)obj;
        return this.top == other.top && this.bottom == other.bottom && this.left == other.left && this.right == other.right;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottom, this.left, this.right);
    }
}

